/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.function.print;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ts.tester.function.CaseResult;
import ts.tester.function.CheckResult;
import ts.tester.function.Result;
import ts.tester.function.ResultType;
import ts.tester.function.print.AbstractPrinter;
import ts.tester.function.print.Printer;

public class PrinterGroupBase
extends AbstractPrinter {
    private List<Printer> printerLst_ = new LinkedList<Printer>();
    private Map<CaseResult, Printer> caseToPrinterMap_ = new HashMap<CaseResult, Printer>();

    public void addPrinter(Printer printer) {
        assert (printer != null) : "@param:printer is null.";
        this.printerLst_.add(printer);
    }

    protected List<Printer> printerList() {
        return this.printerLst_;
    }

    @Override
    public void setStopped(boolean bl) {
        super.setStopped(bl);
        for (Printer printer : this.printerLst_) {
            printer.setStopped(bl);
        }
    }

    @Override
    public CaseResult createCaseResult(String string, CaseResult caseResult) {
        CaseResultGroup caseResultGroup = new CaseResultGroup(string, caseResult);
        if (caseResult instanceof CaseResultGroup) {
            for (CaseResult caseResult2 : ((CaseResultGroup)caseResult).caseLst_) {
                Printer printer = this.caseToPrinterMap_.get(caseResult2);
                CaseResult caseResult3 = printer.createCaseResult(string, caseResult2);
                caseResultGroup.caseLst_.add(caseResult3);
                this.caseToPrinterMap_.put(caseResult3, printer);
            }
        } else {
            for (Printer printer : this.printerLst_) {
                CaseResult caseResult4 = printer.createCaseResult(string, caseResult);
                caseResultGroup.caseLst_.add(caseResult4);
                this.caseToPrinterMap_.put(caseResult4, printer);
            }
        }
        return caseResultGroup;
    }

    @Override
    public void testStarted(CaseResult caseResult) {
        assert (caseResult != null) : "@param:root is null.";
        assert (caseResult instanceof CaseResultGroup) : "@param:root is an intance of unsupported CaseResult class.";
        CaseResultGroup caseResultGroup = (CaseResultGroup)caseResult;
        for (CaseResult caseResult2 : caseResultGroup.caseLst_) {
            Printer printer = this.caseToPrinterMap_.get(caseResult2);
            printer.testStarted(caseResult2);
        }
    }

    @Override
    public void testEnded(CaseResult caseResult) {
        assert (caseResult != null) : "@param:root is null.";
        assert (caseResult instanceof CaseResultGroup) : "@param:root is an intance of unsupported CaseResult class.";
        CaseResultGroup caseResultGroup = (CaseResultGroup)caseResult;
        for (CaseResult caseResult2 : caseResultGroup.caseLst_) {
            Printer printer = this.caseToPrinterMap_.get(caseResult2);
            printer.testEnded(caseResult2);
        }
    }

    @Override
    public void caseStarted(CaseResult caseResult) {
        assert (caseResult != null) : "@param:current is null.";
        assert (caseResult instanceof CaseResultGroup) : "@param:current is an intance of unsupported CaseResult class.";
        CaseResultGroup caseResultGroup = (CaseResultGroup)caseResult;
        for (CaseResult caseResult2 : caseResultGroup.caseLst_) {
            Printer printer = this.caseToPrinterMap_.get(caseResult2);
            printer.caseStarted(caseResult2);
        }
    }

    @Override
    public void caseEnded(CaseResult caseResult) {
        assert (caseResult != null) : "@param:current is null.";
        assert (caseResult instanceof CaseResultGroup) : "@param:current is an instance of unsuppoerted CaseResult class.";
        CaseResultGroup caseResultGroup = (CaseResultGroup)caseResult;
        for (CaseResult caseResult2 : caseResultGroup.caseLst_) {
            Printer printer = this.caseToPrinterMap_.get(caseResult2);
            printer.caseEnded(caseResult2);
        }
    }

    @Override
    public void checkOccured(CheckResult checkResult, CaseResult caseResult) {
        assert (checkResult != null) : "@param:check is null.";
        assert (caseResult != null) : "@param:current is null.";
        assert (caseResult instanceof CaseResultGroup) : "@param:current is an instance of unsuppoerted CaseResult class.";
        CaseResultGroup caseResultGroup = (CaseResultGroup)caseResult;
        for (CaseResult caseResult2 : caseResultGroup.caseLst_) {
            Printer printer = this.caseToPrinterMap_.get(caseResult2);
            printer.checkOccured(checkResult, caseResult2);
        }
    }

    @Override
    public void messageNoted(String string, CaseResult caseResult) {
        assert (string != null) : "@param:message is null.";
        assert (caseResult != null) : "@param:current is null.";
        assert (caseResult instanceof CaseResultGroup) : "@param:current is an instance of unsupported CaseResult class.";
        CaseResultGroup caseResultGroup = (CaseResultGroup)caseResult;
        for (CaseResult caseResult2 : caseResultGroup.caseLst_) {
            Printer printer = this.caseToPrinterMap_.get(caseResult2);
            printer.messageNoted(string, caseResult2);
        }
    }

    private class CaseResultGroup
    extends CaseResult {
        private List<CaseResult> caseLst_;

        CaseResultGroup(String string, CaseResult caseResult) {
            super(string, caseResult);
            this.caseLst_ = new LinkedList<CaseResult>();
        }

        @Override
        public void addMessage(String string) {
            super.addMessage(string);
            for (CaseResult caseResult : this.caseLst_) {
                caseResult.addMessage(string);
            }
        }

        @Override
        public int count(ResultType resultType) {
            assert (resultType != null) : "@param:type is null.";
            if (this.caseLst_.size() == 0) {
                return 0;
            }
            CaseResult caseResult = this.caseLst_.get(0);
            return caseResult.count(resultType);
        }

        @Override
        public void addChildResult(Result result) {
            assert (result != null) : "@param:result is null.";
            if (result instanceof CaseResultGroup) {
                for (CaseResult caseResult : ((CaseResultGroup)result).caseLst_) {
                    CaseResult caseResult2 = caseResult.getParentCaseResult();
                    caseResult2.addChildResult(caseResult);
                }
            } else {
                for (CaseResult caseResult : this.caseLst_) {
                    caseResult.addChildResult(result);
                }
            }
        }
    }
}

