/*
 * DefaultMapComparator class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import ts.util.GeneralComparator;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.LinkedHashSet;
import java.util.Collections;

/**
 * Q̃}bv̑召r{@link ts.util.table.MapComparator MapComparator}
 * C^[tFCX̃ftHgNXB
 * <br>
 * ̃C^[tFCX{@link #comparingKeys()}\bhɂē
 * Ce[^L[ɎoāAɑΉ}bv̒l̑召
 * rB
 * <br>
 * l̑召́Aw肳ꂽ2̒lIuWFNĝ̂ꂩ{@link
 * java.lang.Comparable Comparable}IuWFNgł΁A{@link
 * java.lang.Comparable#compareTo(java.lang.Object) compareTo}\bhgp
 * Ĕ肵AłȂΒlIuWFNg𕶎ɕϊĔrB
 * <br>
 * ܂IvVƂāAl̑召tɂĕԂAkƔkEIuWFNg
 * rƂ̑召w肵ł悤ɂ邽߂̃\bhpӂ
 * B
 *
 * @param <K> ̃}bṽL[̃^CvB
 * @param <V> ̃}bv̒l̃^CvB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/10/09 17:04:52 $
 */
public class DefaultMapComparator<K,V> implements MapComparator<K,V>
{
  /** rɎgpL[i[ZbgB */
  private LinkedHashSet<K> keySet_ = new LinkedHashSet<K>();

  /** l̔rɎgp{@link ts.util.GeneralComparator GeneralComparator} */
  private static GeneralComparator cmp_ = new GeneralComparator();

  /** l̑召֌W̋tɂ邩ǂ񋓌^NXB */
  public enum Direction { NORMAL, REVERSE }

  /** kƔkEIuWFNg̑召֌W񋓌^NXB */
  public enum NullOrder { GREATEST, LEAST }

  /** l̑召֌Wtɂ邩ǂtOB */
  private Direction direction_ = Direction.NORMAL;

  /** kƔkEIuWFNg̑召֌WtOB */
  private NullOrder nullOrder_ = NullOrder.GREATEST;

  /**
   * ftHgRXgN^B
   */
  public DefaultMapComparator()
  {}

  /**
   * CfbNXEL[ɂƂRXgN^B 
   *
   * @param  indexKeys CfbNXEL[̔zB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public DefaultMapComparator(K ... indexKeys)
  {
    for (K key : indexKeys) {
      addKey(key);
    }
  }

  /**
   * l̑召֌Wtɂ邩ǂtOݒ肷B
   *
   * @param  dir l̑召֌Wtɂ邩ǂtOlB
   */
  public void setDirection(Direction dir)
  {
    direction_ = dir;
  }

  /**
   * kƔkEIuWFNg̑召֌WtOB
   *
   * @param  nullOrder kƔkEIuWFNg̑召֌WtOlB
   */
  public void setNullOrder(NullOrder nullOrder)
  {
    nullOrder_ = nullOrder;
  }

  /**
   * rɎgpL[ǉB
   *
   * @param  key L[B
   */
  public void addKey(K key)
  {
    keySet_.add(key);
  }

  /**
   * }bv̔rɎgpL[񋓂B
   *
   * @return }bv̔rɎgpL[̗񋓃IuWFNgB
   */
  public Enumeration<K> comparingKeys()
  {
    return Collections.enumeration(keySet_);
  }

  /**
   * {@link #comparingKeys()}\bhɂēL[ɑΉtꂽl
   * rA}bv̑召𔻒肷B
   * <br>
   * l̔r@́A{@link ts.util.GeneralComparator GeneralComparator}ɏ]
   * ƂƂB
   *
   * @param  m1 rΏۂ̃}bv1B
   * @param  m2 rΏۂ̃}bv2B
   * @return m1m2菬ꍇ͕̒lAm1m2傫ꍇ͐̒lA
   *         m1m2ꍇ̓[ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   * @see ts.util.GeneralComparator
   */
  public int compare(Map<K,V> m1, Map<K,V> m2)
  {
    assert (m1 != null) : "@param:m1 is null.";
    assert (m2 != null) : "@param:m2 is null.";

    Enumeration<K> enm = comparingKeys();
    while (enm.hasMoreElements()) {
      K key = enm.nextElement();
      V v1 = m1.get(key);
      V v2 = m2.get(key);
      int ret = cmp_.compare(v1, v2);
      if (ret != 0) {
        if (v1 == null || v2 == null) {
          if (nullOrder_.equals(NullOrder.LEAST)) {
            ret *= -1;
          }
        }
        if (direction_.equals(Direction.REVERSE)) {
          ret *= -1;
        }
        return ret;
      }
    }

    return 0;
  }

  /**
   * ̃IuWFNg̃IuWFNgɓǂ𔻒肷B
   *
   * @param  obj rΏۂ̃IuWFNgB
   * @return ꍇ<tt>true</tt>AłȂꍇ<tt>false</tt>ԂB
   */
  public boolean equals(Object obj)
  {
    return super.equals(obj);
  }
}

