/*
 * ConstraintViolationException class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import ts.util.ReasonedRuntimeException;

/**
 * e[u̍XVɂĐᔽꍇɃX[ONXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/10/20 09:40:04 $
 */
public class ConstraintViolationException extends ReasonedRuntimeException
{
  /** VAEo[WԍB*/
  static final long serialVersionUID = -9065975772757871421L;

  /** ̎ށB */
  private Trigger.Action action_ ;

  /** ̐ᔽOIuWFNgB */
  private ConstraintViolationException next_ = null;

  /**
   * ̎ނɂƂRXgN^B
   *
   * @param  action ̎ށB
   * @throws AssertionError ̎ނk̏ꍇifobOE[ĥ݁jB
   */
  public ConstraintViolationException(Trigger.Action action)
  {
    assert (action != null) : "@param:action is null.";
    action_ = action;
  }

  /**
   * ̎ނƁAR{@link java.lang.Enum Enum}IuWFNg
   * ƂRXgN^B
   *
   * @param  action ̎ށB
   * @param  reason R{@link java.lang.Enum Enum}IuWFNgB
   * @throws AssertionError ̎ނk̏ꍇifobOE[ĥ݁jB
   */
  public ConstraintViolationException(Trigger.Action action, Enum reason)
  {
    super(reason);
    assert (action != null) : "@param:action is null.";
    action_ = action;
  }

  /**
   * ̎ނƁAR{@link java.lang.Enum Enum}IuWFNgƁAO
   * bZ[WɂƂRXgN^B
   *
   * @param  action ̎ށB
   * @param  reason R{@link java.lang.Enum Enum}IuWFNgB
   * @param  msg ObZ[WB
   * @throws AssertionError ̎ނk̏ꍇifobOE[ĥ݁jB
   */
  public ConstraintViolationException(Trigger.Action action, Enum reason,
    String msg)
  {
    super(reason, msg);
    assert (action != null) : "@param:action is null.";
    action_ = action;
  }

  /**
   * ̎ނƁAR{@link java.lang.Enum Enum}IuWFNgƗO
   * bZ[WA̗ǑƂȂ{@link java.lang.Throwable Throwable}
   * IuWFNgɂƂRXgN^B
   *
   * @param  action ̎ށB
   * @param  reason R{@link java.lang.Enum Enum}IuWFNgB
   * @param  msg ObZ[WB
   * @param  cause ̗ǑƂȂ{@link java.lang.Throwable Throwable}
   *           IuWFNgB
   * @throws AssertionError ̎ނk̏ꍇifobOE[ĥ݁jB
   */
  public ConstraintViolationException(Trigger.Action action, Enum reason,
    String msg, Throwable cause)
  {
    super(reason, msg, cause);
    assert (action != null) : "@param:action is null.";
    action_ = action;
  }

  /**
   * ̎ނƁAR{@link java.lang.Enum Enum}IuWFNgƁA
   * ̗ǑƂȂ{@link java.lang.Throwable Throwable }IuWFNg
   * ɂƂRXgN^B
   *
   * @param  action ̎ށB
   * @param  reason R{@link java.lang.Enum Enum}IuWFNgB
   * @param  cause ̗ǑƂȂ{@link java.lang.Throwable Throwable}
   *           IuWFNgB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public ConstraintViolationException(Trigger.Action action, Enum reason,
    Throwable cause)
  {
    super(reason, cause);
    assert (action != null) : "@param:action is null.";
    action_ = action;
  }

  /**
   * ̗OX[ꂽ̎ނ擾B
   *
   * @return ̎ށB
   */
  public Trigger.Action getAction()
  {
    return action_ ;
  }

  /**
   * ObZ[W擾B
   *
   * @return ObZ[WB
   */
  public String getMessage()
  {
    StringBuffer buf = new StringBuffer();
    buf.append("[").append(getAction().name()).append("]");

    buf.append("[");
    Enum reason = getReason();
    if (reason != null) {
      buf.append(reason.name());
    }
    buf.append("]");

    String msg = super.getMessage();
    if (msg != null) {
      buf.append(" ").append(msg);
    }
    else {
      Throwable t = getCause();
      if (t != null) {
        buf.append(" ").append(t.toString());
      }
    }
    return buf.toString();
  }

  /**
   * ̐ᔽOIuWFNgݒ肷B
   * <br>
   * Ƀkݒ肳ꂽꍇ́Â܂܃kݒ肷B
   *
   * @param  exc ̐ᔽOIuWFNgB
   */
  public void setNext(ConstraintViolationException exc)
  {
    next_ = exc;
  }

  /**
   * ̐ᔽOIuWFNg擾B
   * <br>
   * ̐ᔽOIuWFNg݂Ȃꍇ̓kԂB
   *
   * @return ̐ᔽOIuWFNgB
   */
  public ConstraintViolationException next()
  {
    return next_ ;
  }
}
