/*
 * ProcessLifetime class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.lifetime;

/**
 * vZX̏Iɍ킹ĐԂ肷{@link ts.util.lifetime.Lifetime
 * Lifetime}NXB
 * <br>
 * w肳ꂽvZX̏ImāAi[Ă{@link ts.util.lifetime.Life
 * Life}IuWFNg{@link ts.util.lifetime.Life#willDie() willDie()}\bh
 * ĂяoB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/06/25 16:20:44 $
 */
public class ProcessLifetime extends Lifetime
{
  /**
   * ftHgERXgN^B  
   */
  public ProcessLifetime()
  {}

  /**
   * Ԃ肷{@link java.lang.Process Process}IuWFNgݒ肷B
   *
   * @param  process Ԃ肷{@link java.lang.Process Process}
   *           IuWFNgB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public void setLifeLong(final Process process)
  {
    assert (process != null) : "@param:process is null.";

    Thread notifyThread = new Thread() {
      public void run() {
        try {
          process.waitFor();
          processEnded(process);
        }
        catch (Exception e) {
          catchProcessException(e, process);
        }
        finally {
          kill();
        }
      }
    };
    notifyThread.start();
  }

  /**
   * vZX̏IɌĂ΂郁\bhB
   * <br>
   * vZX̏IR[h𒲂ׂȂǁAvZX̏Iɉ̏s
   * ꍇ́Ã\bhI[o[ChB
   * <br>
   * ̃NXł́AȂB
   *
   * @param  process vZXEIuWFNgB
   */
  protected void processEnded(Process process)
  {}

  /**
   * vZX̏I҂ĂԂɗOꍇɁA̗O󂯕tB
   * <br>
   * Oɉ炩̏sꍇɂ́Ã\bhI[o[Ch
   * B
   * <br>
   * ̃NXł́AȂB
   * 
   * @param  exc OB
   * @param  process vZXEIuWFNgB
   */
  protected void catchProcessException(Exception exc, Process process)
  {}
}

