/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import com.ozacc.mail.trotter.Config;
import com.ozacc.mail.trotter.Person;
import com.ozacc.mail.trotter.SendMail;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.w3c.dom.Element;

class SendMailImpl
implements SendMail {
    protected Config config;
    protected Session session = Session.getInstance((Properties)new Properties(), null);
    protected Transport transport = this.session.getTransport("smtp");
    protected String host;
    protected MimeMessage mail = new MimeMessage(this.session);
    protected Log log = LogFactory.getLog(this.getClass());
    protected static int count = 0;
    protected long interval = 500L;

    SendMailImpl() throws NoSuchProviderException {
    }

    public void connect() throws MessagingException {
        if (this.host == null) {
            throw new MessagingException("SMTP\u30b5\u30fc\u30d0\u306e\u30db\u30b9\u30c8\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        try {
            this.transport.connect(this.host, -1, null, null);
        }
        catch (MessagingException messagingException) {
            throw new MessagingException("SMTP\u30b5\u30fc\u30d0\u3078\u306e\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public void close() throws MessagingException {
        this.transport.close();
    }

    public synchronized void send(Person person) throws MessagingException {
        ++count;
        try {
            this.mail.setRecipient(Message.RecipientType.TO, (Address)person.getInternetAddress());
            this.mail.setSentDate(new Date());
            this.mail.saveChanges();
            this.transport.sendMessage((Message)this.mail, this.mail.getAllRecipients());
            this.log.info((Object)(count + " Send OK\t" + person));
            if (this.config.isMonitored()) {
                System.out.println(count + ": " + person);
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (AddressException addressException) {
            this.log.warn((Object)(count + " Send Error (" + addressException.getMessage() + ")\t" + person));
        }
        catch (MessagingException messagingException) {
            this.log.fatal((Object)(count + " Fatal Error (SMTP\u30b5\u30fc\u30d0\u3068\u306e\u3084\u308a\u3068\u308a\u306e\u4e2d\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\u914d\u4fe1\u3092\u4e2d\u6b62\u3057\u307e\u3059\u3002"));
            throw new MessagingException("SMTP\u30b5\u30fc\u30d0\u3068\u306e\u3084\u308a\u3068\u308a\u306e\u4e2d\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public void setConfig(Config config) throws MessagingException {
        this.config = config;
        this.setHost(config.getHost());
        this.setSubject(config.getSubject());
        this.setFrom(config.getInternetAddress());
        this.setReturnPath(config.getReturnPath());
        this.setInterval(config.getInterval());
        if (config.getLog4jConfig() != null) {
            DOMConfigurator.configure((Element)config.getLog4jConfig());
        }
        if (config.getHeaders() != null) {
            Properties properties = config.getHeaders();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                this.addHeader(string, properties.getProperty(string));
            }
        }
    }

    private void setHost(String string) {
        this.host = string;
    }

    public void setBody(String string) throws MessagingException {
        try {
            this.mail.setText(string, "ISO-2022-JP");
            this.mail.setHeader("Content-Transfer-Encoding", "7bit");
        }
        catch (MessagingException messagingException) {
            throw new MessagingException("\u672c\u6587\u306e\u30bb\u30c3\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
        }
    }

    private void setSubject(String string) throws MessagingException {
        this.mail.setSubject(string, "ISO-2022-JP");
    }

    private void setFrom(InternetAddress internetAddress) throws MessagingException {
        this.mail.setFrom((Address)internetAddress);
    }

    private void setReturnPath(String string) {
        this.session.getProperties().put("mail.smtp.from", string);
    }

    private void addHeader(String string, String string2) throws MessagingException {
        this.mail.addHeader(string, string2);
    }

    private void setInterval(long l) {
        if (l >= 0L) {
            this.interval = l;
        }
    }
}

