/*
 * Decompiled with CFR 0.152.
 */
package com.ozacc.mail.trotter;

import com.ozacc.mail.trotter.Column;
import com.ozacc.mail.trotter.Config;
import com.ozacc.mail.trotter.ListReader;
import com.ozacc.mail.trotter.Person;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class CSVListReader
implements ListReader {
    private Config config;
    private BufferedReader br;
    private String line;
    private boolean flag;
    private List columnList;
    private int cnt;
    private static CSVListReader instance;

    private CSVListReader(Config config) {
        this.config = config;
        this.columnList = config.getColumnList();
        this.cnt = this.columnList.size();
    }

    static synchronized ListReader getInstance(Config config) {
        if (instance == null) {
            instance = new CSVListReader(config);
        }
        return instance;
    }

    public void open() throws IOException {
        try {
            this.br = new BufferedReader(new FileReader(this.config.getListFileName()));
        }
        catch (IOException iOException) {
            throw new IOException("\u30ea\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
        }
    }

    public void close() throws IOException {
        this.br.close();
    }

    public Person next() throws NoSuchElementException {
        if (this.line == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        Person person = new Person();
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.line, ",");
            for (int i = 0; i < this.cnt; ++i) {
                String string = stringTokenizer.nextToken().trim();
                Column column = (Column)this.columnList.get(i);
                if (column.getType() == 1) {
                    person.setName(string);
                    continue;
                }
                if (column.getType() == 2) {
                    person.setEmail(string);
                    continue;
                }
                person.put(column.getName(), string);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306eCSV\u30b9\u30ad\u30fc\u30de\u3068\u5b9f\u969b\u306eCSV\u30d5\u30a1\u30a4\u30eb\u306e\u30b9\u30ad\u30fc\u30de\u304c\u4e00\u81f4\u3057\u3066\u3044\u306a\u3044\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
        }
        finally {
            this.flag = false;
            this.line = null;
        }
        return person;
    }

    public boolean hasNext() {
        try {
            if (!this.flag) {
                this.line = this.br.readLine();
                if (this.line != null) {
                    this.flag = true;
                    return true;
                }
                return false;
            }
            return this.line != null;
        }
        catch (IOException iOException) {
            this.flag = false;
            return false;
        }
    }
}

