/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: eggArc.cpp 96 2009-11-11 14:38:24Z sirakaba $
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include "../../common/header/plugin.h"
#include "../../common/header/plugin-extra.h"
#include "../../common/library/library.h"
#include <windows.h>
#include "eggArc.h"

//******************************************************************************
//    Global varients
//******************************************************************************

HMODULE g_hLib;
TPI_PROC g_prProc;
TPI_SWITCHES * g_swInfo;
const wxArrayString * g_asFiles;

//******************************************************************************
//    Callback Wrapper
//******************************************************************************

UINT __cdecl CallbackProc(void * user, UINT code, void* param)
{
	// \̂B
	static TPI_PROCESSINFO piInfo;
	piInfo.uMessage = TPI_MESSAGE_STATUS;

	switch (code)
	{
	case eggevent::Start::CODE:
		piInfo.uStatus = TPI_STATUS_OPENARCHIVE;
		break;
	case eggevent::Extract::CODE:
	{
		// WJ邩ǂfB
		// TODO : AvP[VցB
		eggevent::Extract * p = (eggevent::Extract *) param;
		wxString szFileName = WC2String(p->nameInArchive);
		if (g_asFiles->Count() != 0 && g_asFiles->Index(szFileName) == wxNOT_FOUND)
		{
			return EGG_ERROR_SKIP;
		}

		// WJB
		wcsncpy(p->fileName, (g_swInfo->fnDestinationDirectory.GetPathWithSep() + (g_swInfo->fStoreDirectoryPathes ? szFileName : wxFileName(szFileName).GetFullName())).wchar_str(), MAX_PATH - 1);
		return EGG_ERROR_SUCCESS;
	}
	case eggevent::ActivityStart::CODE:
		piInfo.uStatus = TPI_STATUS_BEGINPROCESS;
		GetFileInformation(* (void **) user, & piInfo.fiInfo, ((eggevent::ActivityStart *) param)->index == 0);
		break;
	case eggevent::Progress::CODE:
		piInfo.uStatus = TPI_STATUS_INPROCESS;
		piInfo.llProcessedSize = ((eggevent::Progress *) param)->current * (piInfo.fiInfo.llUnpackedSize.ToULong() / 10000);
		break;
	case eggevent::ActivityFinish::CODE:
		piInfo.uStatus = TPI_STATUS_ENDPROCESS;
		break;
	case eggevent::Finish::CODE:
		piInfo.uStatus = TPI_STATUS_CLOSEARCHIVE;
		break;
	case eggevent::QueryPassword::CODE:
	{
		// pX[h₢킹B
		// TODO : ʃt@Cɑ΂₢킹̎B
		piInfo.uMessage = TPI_MESSAGE_ASK;
		piInfo.uStatus  = TPI_PARAM_PASSWORD;

		// R[obN֐ɑMB
		eggevent::QueryPassword * p = (eggevent::QueryPassword *) param;
		// ͊̃pX[hB
		if (p->queryCount == 1)
		{
			wcsncpy(p->password, g_swInfo->szPassword.wchar_str(), 1024 - 1);
			return EGG_ERROR_SUCCESS;
		}

		// 2ڈȍ~̓R[obN֐ɑMB
		if (g_prProc == NULL || g_prProc(TPI_NOTIFY_COMMON, & piInfo) != TPI_CALLBACK_CONTINUE)
		{
			return EGG_ERROR_CANCEL;
		}

		// ̃pX[hύXĂB
		g_swInfo->szPassword = piInfo.szParam;
		wcsncpy(p->password, piInfo.szParam.wchar_str(), 1024 - 1);
		return EGG_ERROR_SUCCESS;
	}
	default:
		return EGG_ERROR_SUCCESS;
	}

	// R[obN֐ɑMB
	if (g_prProc == NULL)
	{
		return EGG_ERROR_SUCCESS;
	}

	return g_prProc(TPI_NOTIFY_COMMON, & piInfo) != TPI_CALLBACK_CANCEL ? EGG_ERROR_SUCCESS : EGG_ERROR_CANCEL;
}

//******************************************************************************
//    Inside Functions
//******************************************************************************

#define GetAPIAddress(name) GetProcAddress(g_hLib, "EGG_" name)

int nErrorCodeConvert(int nErrorCode)
{
	switch (nErrorCode)
	{
	case EGG_ERROR_FAIL:        return TPI_ERROR_UNDEFINED;
	case EGG_ERROR_SUCCESS:     return TPI_ERROR_SUCCESS;
	case EGG_ERROR_SKIP:        return TPI_ERROR_D_SKIPPED;
	case EGG_ERROR_CANCEL:      return TPI_ERROR_D_SKIPPED;
	case EGG_ERROR_IO:          return TPI_ERROR_IO_MISC;
	case EGG_ERROR_TYPEMISMATCH:return TPI_ERROR_ARC_UNSUPPORTED;
	case EGG_ERROR_FILE:        return TPI_ERROR_IO_MISC;
	case EGG_ERROR_FORMAT:      return TPI_ERROR_IO_ARC_MISC;
	case EGG_ERROR_ALGORITHM:   return TPI_ERROR_UNDEFINED;
	default:                    return TPI_ERROR_UNDEFINED;
	}
}

//******************************************************************************
//    Functions
//******************************************************************************

#ifdef __cplusplus
extern "C"
{
#endif

int __stdcall GetPluginInformation
(
	unsigned int _uInfoId,
	wxULongLong,
	void * _pPtr
)
{
	if (_pPtr == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	switch (LOWORD(_uInfoId))
	{
	case TPI_INFO_VERSION_MAJOR:
	case TPI_INFO_VERSION_MINOR:
		* (int *) _pPtr = 0;
		break;
	case TPI_INFO_VERSION_API:
		* (int *) _pPtr = 2;
		break;
	default:
		return TPI_ERROR_D_UNSUPPORTED;
	}
	return TPI_ERROR_SUCCESS;
}

int __stdcall GetFormatInformation(TPI_FORMATINFO * _fiInfo, bool _bFirst)
{
	if (! _bFirst)
	{
		return TPI_ERROR_S_ENDOFDATA;
	}

	_fiInfo->szTypeName   = wxT("EGG/ALZ");
	_fiInfo->szSuffix     = wxT(".egg;.alz");
	_fiInfo->szEngineName = wxT("UnEGG.dll");
	_fiInfo->szTPIName    = wxT("eggArc");
	_fiInfo->llTypeId     = 0;
	_fiInfo->llSupportedCommand = TPI_COMMAND_EXTRACT;
	_fiInfo->fComment     = true;
	_fiInfo->fSFX         = true;
	_fiInfo->fSolid       = true;
	_fiInfo->fEncryptPassword = true;
	_fiInfo->fMultiVolume = true;

	return TPI_ERROR_SUCCESS;
}

int __stdcall LoadPlugin
(
	const wxString & _szArcName,
	wxULongLong
)
{
	g_hLib = ::LoadLibrary(L"UnEGG.dll");
	if (g_hLib == NULL || CheckArchive(_szArcName, NULL) != TPI_ERROR_SUCCESS)
	{
		::FreeLibrary(g_hLib);
		return TPI_ERROR_U_LOAD_LIBRARY;
	}

	return TPI_ERROR_SUCCESS;
}

int __stdcall FreePlugin
(
	void * // _pReserved
)
{
	::FreeLibrary(g_hLib);
	return TPI_ERROR_SUCCESS;
}

int __stdcall CheckArchive
(
	const wxString & _szArcName,
	int * _nFileCount
)
{
	FARPROC fpProc = ::GetAPIAddress("IsValidArchive");
	if (fpProc == NULL)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	if (_nFileCount != NULL)
	{
		* _nFileCount = 1;
	}

	egg_type eType;
	return nErrorCodeConvert(((UINT (__cdecl *)(const wchar_t *, egg_type *)) fpProc)(_szArcName.wchar_str(), & eType));
}

int __stdcall OpenArchive
(
	const wxString & _szArcName,
	void * * _hArchive
)
{
	FARPROC fpProc = ::GetAPIAddress("CreateEgg");
	if (fpProc == NULL)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	int nErrorCode = nErrorCodeConvert(((UINT (__cdecl *)(void **, eggevent::Proc, void *)) fpProc)(_hArchive, CallbackProc, _hArchive));
	if (nErrorCode != TPI_ERROR_SUCCESS)
	{
		return nErrorCode;
	}
	if (_hArchive == NULL)
	{
		return TPI_ERROR_UNDEFINED;
	}

	fpProc = ::GetAPIAddress("OpenArchive");
	return fpProc == NULL ? TPI_ERROR_U_USE_LIBRARY : nErrorCodeConvert(((UINT (__cdecl *)(void *, wchar_t *)) fpProc)(* _hArchive, _szArcName.wchar_str()));
}

int __stdcall CloseArchive
(
	void * _hArchive
)
{
	FARPROC fpProc = ::GetAPIAddress("CloseArchive");
	if (fpProc == NULL || _hArchive == NULL)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	int nErrorCode = nErrorCodeConvert(((UINT (__cdecl *)(void *)) fpProc)(_hArchive));
	if (nErrorCode != TPI_ERROR_SUCCESS)
	{
		return nErrorCode;
	}

	fpProc = ::GetAPIAddress("DestroyEgg");
	return fpProc == NULL ? TPI_ERROR_U_USE_LIBRARY : nErrorCodeConvert(((UINT (__cdecl *)(void **)) fpProc)(& _hArchive));
}

int __stdcall GetFileInformation
(
	void * _hArchive,
	TPI_FILEINFO * _fiInfo,
	bool _bFirst
)
{
	static unsigned int s_uFileID, s_uFileCount;
	static FARPROC fpProc;
	int nErrorCode;

	if (_bFirst)
	{
		s_uFileID = 0;
		fpProc = ::GetAPIAddress("GetFileCount");
		if (fpProc == NULL)
		{
			return TPI_ERROR_U_USE_LIBRARY;
		}
		nErrorCode = nErrorCodeConvert(((UINT (__cdecl *)(void *, size_t *)) fpProc)(_hArchive, & s_uFileCount));
		if (nErrorCode != TPI_ERROR_SUCCESS)
		{
			return nErrorCode;
		}

		fpProc = ::GetAPIAddress("GetFileHeader");
		if (fpProc == NULL)
		{
			return TPI_ERROR_U_USE_LIBRARY;
		}
	}
	if (s_uFileID >= s_uFileCount)
	{
		return TPI_ERROR_S_ENDOFDATA;
	}

	EGGFileHeader fhInfo;
	nErrorCode = nErrorCodeConvert(((UINT (__cdecl *)(void *, size_t, EGGFileHeader *)) fpProc)(_hArchive, s_uFileID, & fhInfo));
	if (nErrorCode == TPI_ERROR_SUCCESS)
	{
		_fiInfo->dwAttribute    = fhInfo.attribute;
		_fiInfo->dwCRC32        = fhInfo.crc;
		_fiInfo->llPackedSize   = fhInfo.packedSize;
		_fiInfo->llUnpackedSize = fhInfo.unpackedSize;
		_fiInfo->tmModified     = fhInfo.lastModified;
		_fiInfo->szStoredName   = WC2String(fhInfo.fileName);
		_fiInfo->szMethod       = fhInfo.method == 2 ? wxT("ALZ") : fhInfo.method == 0 ? wxT("EGG") : wxT("unknown");
		_fiInfo->llFileID       = s_uFileID++;
		_fiInfo->fnFileName     = wxFileName(_fiInfo->szStoredName);
	}

	return nErrorCode;
}

int __stdcall GetArchiveInformation
(
	void *,
	TPI_ARCHIVEINFO * _aiInfo
)
{
	GetFormatInformation(& _aiInfo->fiInfo, true);
	return TPI_ERROR_SUCCESS;
}

int __stdcall Command
(
	unsigned int _uCommand,
	TPI_SWITCHES * _swInfo,
	const wxString & _szArcName,
	const wxArrayString & _szFiles
)
{
	if (_uCommand != TPI_COMMAND_EXTRACT)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	// JȂB
	void * hArc;
	int nErrorCode = OpenArchive(_szArcName, & hArc);
	if (nErrorCode != TPI_ERROR_SUCCESS)
	{
		return nErrorCode;
	}

	// O[oϐɃ|C^ۑB
	g_swInfo = _swInfo;
	g_asFiles = & _szFiles;

	FARPROC fpProc = ::GetAPIAddress("Extract");
	if (fpProc == NULL)
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	nErrorCode = nErrorCodeConvert(((UINT (__cdecl *)(void *)) fpProc)(hArc));
	if (nErrorCode != TPI_ERROR_SUCCESS)
	{
		return nErrorCode;
	}

	return CloseArchive(hArc);
}

int __stdcall SetCallbackProc
(
	TPI_PROC _prArcProc
)
{
	// |C^ۑB
	if (_prArcProc == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	g_prProc = * _prArcProc;

	return TPI_ERROR_SUCCESS;
}

#ifdef __cplusplus
}
#endif
