/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: cuiWrapper.cpp,v 1.26 2009/09/27 13:41:02 sirakaba Exp $
*******************************************************************************/

//******************************************************************************
//    Includes
//******************************************************************************

#include "../../common/header/plugin.h"
#include "../../common/header/plugin-extra.h"
#include "../../common/library/library.h"
#include <wx/config.h>
#include <wx/stdpaths.h>
#include <wx/xml/xml.h>
#include <wx/tokenzr.h>
#include <windows.h>
#include "cuiWrapper.h"

//******************************************************************************
//    Global varients
//******************************************************************************

struct g_LibInfo
{
	wxString szExeFile;
	wxString szExeFileAlt;
	wxString szListCommand;
	int nLibIndex;
	wxXmlNode node;
}	g_LibInfo;

TPI_PROC g_prProc;
wxString g_szCurrentArchive;
wxArrayString g_asOutput;

//******************************************************************************
//    Entry
//******************************************************************************

BOOL __stdcall DllMain(HMODULE, DWORD, void *)
{
	return TRUE;
}

//******************************************************************************
//    Inside Functions
//******************************************************************************

DWORD myExecute(wxString szCommandLine, wxString * szOutput, wxString szCwd, bool bCheckExist = false)
{
#ifdef __LINUX__
	wxString sz = ::wxGetCwd();
	::wxSetWorkingDirectory(szCwd);
	FILE * fp = popen(szCommandLine.ToUTF8(), "r");
	::wxSetWorkingDirectory(sz);
	if (fp == NULL)
	{
//		wxMessageBox(wxString::Format(wxT("Error :\n\nCommandLine:\n%s"), szCommandLine.c_str()));
		return TPI_ERROR_U_USE_LIBRARY;
	}

	if (bCheckExist)
	{
		return TPI_ERROR_SUCCESS;
	}

	if (szOutput != NULL)
	{
		char sz[32769];
		memset(sz, 0, sizeof(sz));
		while (! feof(fp))
		{
			fread(sz, sizeof(char), sizeof(sz) - 1, fp);
			* szOutput += UTF82String(sz);
		}
//		::wxMessageBox(* szOutput);
	}

	pclose(fp);
	return TPI_ERROR_SUCCESS;
#else
	SECURITY_ATTRIBUTES sa;
	memset(& sa, 0, sizeof(SECURITY_ATTRIBUTES));
	sa.bInheritHandle = TRUE;
	sa.nLength = sizeof(SECURITY_ATTRIBUTES);
	HANDLE hRead, hWrite;
	if (! ::CreatePipe(& hRead, & hWrite, & sa, 65537))
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}
	STARTUPINFO si;
	memset(& si, 0, sizeof(STARTUPINFO));
	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESTDHANDLES;
	si.hStdOutput = hWrite;
	si.hStdError = hWrite;
	PROCESS_INFORMATION pi;
	if (! ::CreateProcess(NULL, szCommandLine.wchar_str(), NULL, NULL, TRUE, CREATE_NO_WINDOW, NULL, szCwd.IsEmpty() ? NULL : szCwd.wchar_str(), & si, & pi))
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	::WaitForInputIdle(pi.hProcess, INFINITE);
	::WaitForSingleObject(pi.hProcess, INFINITE);

	DWORD nErrorCode = 0;
	::GetExitCodeProcess(pi.hProcess, & nErrorCode);
	::CloseHandle(pi.hThread);
	::CloseHandle(pi.hProcess);

	if (bCheckExist)
	{
		return TPI_ERROR_SUCCESS;
	}

	if (szOutput != NULL)
	{
		DWORD dwSize = 0;
		char sz[32769];
		memset(sz, 0, sizeof(sz));
		for (wxULongLong llSize = 0; llSize < ::GetFileSize(hRead, NULL); llSize += dwSize)
		{
			dwSize = 0;
			::ReadFile(hRead, sz, sizeof(sz) - 1, & dwSize, NULL);
			* szOutput += UTF82String(sz);
//			::MessageBoxA(NULL, sz, NULL, 0);
		}
	}
	::CloseHandle(hRead);
	::CloseHandle(hWrite);

	return nErrorCode == 0 ? TPI_ERROR_SUCCESS : TPI_ERROR_UNDEFINED;
#endif
}

PosInfo MakePosInfo(wxString szPrefix)
{
	PosInfo pi;
	g_LibInfo.node.GetPropVal(wxT("list-") + szPrefix + wxT("-s"), wxEmptyString).ToULong(& pi.nStart);
	g_LibInfo.node.GetPropVal(wxT("list-") + szPrefix + wxT("-c"), wxEmptyString).ToULong(& pi.nCount);
	g_LibInfo.node.GetPropVal(wxT("list-") + szPrefix + wxT("-l"), wxT("0")).ToULong(& pi.nLine);
	return pi;
}

wxULongLong GetSize(PosInfo & pi, size_t uCurrent, wxArrayString & as)
{
	if (pi.nStart == 0 && pi.nCount == 0)
	{
		return 0;
	}

	wxULongLong_t nTemp;
	size_t nPos = uCurrent + pi.nLine;
	wxString sz = pi.nCount == 0 ? as[nPos].Mid(pi.nStart) : as[nPos].Mid(pi.nStart, pi.nCount);
	sz.ToULongLong(& nTemp);
	return nTemp;
}

//******************************************************************************
//    Functions
//******************************************************************************

#ifdef __cplusplus
extern "C"
{
#endif

int __stdcall GetPluginInformation
(
	unsigned int _uInfoId,
	wxULongLong,
	void * _pPtr
)
{
	if (_pPtr == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	switch (LOWORD(_uInfoId))
	{
	case TPI_INFO_VERSION_MAJOR:
	case TPI_INFO_VERSION_MINOR:
		* (int *) _pPtr = 0;
		break;
	case TPI_INFO_VERSION_API:
		* (int *) _pPtr = 2;
		break;
	default:
		return TPI_ERROR_D_UNSUPPORTED;
	}
	return TPI_ERROR_SUCCESS;
}

int __stdcall GetFormatInformation(TPI_FORMATINFO * _fiInfo, bool _bFirst)
{
	static unsigned int s_uFileID;
	wxStandardPaths p;
	wxXmlDocument config(wxPathOnly(p.GetExecutablePath()) + wxT("/lib/cuiWrapper.xml"));
	// Cɐ擪̃Cȕ擾B
	wxXmlNode * xmlLibrary = config.GetRoot()->GetChildren();

	if (_bFirst)
	{
		// xml͊JnB
		s_uFileID = 0;
	}
	else
	{
		for (unsigned int i = 0; i < s_uFileID && xmlLibrary != NULL; i++)
		{
			xmlLibrary = xmlLibrary->GetNext();
		}
	}

	if (xmlLibrary == NULL || xmlLibrary->GetName() != wxT("library"))
	{
		// I[ɒBꍇB
		return TPI_ERROR_S_ENDOFDATA;
	}

	MakeFormatInfo(wxT("cuiWrapper"), _fiInfo, xmlLibrary, s_uFileID++);
	if (myExecute(xmlLibrary->GetPropVal(wxT("name"), wxEmptyString), NULL, wxEmptyString, true) != TPI_ERROR_SUCCESS)
	{
		_fiInfo->llSupportedCommand = 0;
	}

	return TPI_ERROR_SUCCESS;
}

int __stdcall LoadPlugin
(
	const wxString & _szArcName,
	wxULongLong _llSubOption
)
{
	// xml͊JnB
	wxStandardPaths p;
	wxXmlDocument config(wxPathOnly(p.GetExecutablePath()) + wxT("/lib/cuiWrapper.xml"));
	if (! config.IsOk())
	{
		return TPI_ERROR_UNDEFINED;
	}
	// Cɐ擪̃Cȕ擾B
	wxXmlNode * xmlLibrary = config.GetRoot()->GetChildren();

	// Ώۂ݂ȂΑΉ郉Cu𒲍A
	// Ώۂ݂ȂȂΎwꂽCu[hB
	if (! ::wxFileExists(_szArcName))
	{
		// KȈʒu܂ňړB
		for (g_LibInfo.nLibIndex = 0; g_LibInfo.nLibIndex < _llSubOption && xmlLibrary != NULL; g_LibInfo.nLibIndex++)
		{
			xmlLibrary = xmlLibrary->GetNext();
		}
		if (xmlLibrary == NULL || xmlLibrary->GetName() != wxT("library"))
		{
			// xml@G[B
			return TPI_ERROR_UNDEFINED;
		}
		g_LibInfo.szExeFile = xmlLibrary->GetPropVal(wxT("name"), wxEmptyString);
		g_LibInfo.szExeFileAlt = xmlLibrary->GetPropVal(wxT("name-alt"), wxEmptyString);
		g_LibInfo.node = * xmlLibrary;

		return TPI_ERROR_SUCCESS;
	}

	// [vɊׂȂ悤ݒB
	for (g_LibInfo.nLibIndex = 0; g_LibInfo.nLibIndex < 300 && xmlLibrary != NULL; g_LibInfo.nLibIndex++)
	{
		// Cu[hB
		g_LibInfo.szExeFile = xmlLibrary->GetPropVal(wxT("name"), wxEmptyString);
		g_LibInfo.szExeFileAlt = xmlLibrary->GetPropVal(wxT("name-alt"), wxEmptyString);
		g_LibInfo.node = * xmlLibrary;

		// ɂɑΉĂ邩`FbNB
		if (CheckArchive(_szArcName, NULL) == TPI_ERROR_SUCCESS)
		{
			// ΉĂΏIB
			return TPI_ERROR_SUCCESS;
		}

		xmlLibrary = xmlLibrary->GetNext();
	}

	return TPI_ERROR_U_LOAD_LIBRARY;
}

int __stdcall FreePlugin
(
	void * // _pReserved
)
{
	return TPI_ERROR_SUCCESS;
}

int __stdcall CheckArchive
(
	const wxString & _szArcName,
	int * _nFileCount
)
{
	wxFileName fnArchive(_szArcName);
	wxArrayString asExt = ::wxStringTokenize(g_LibInfo.node.GetPropVal(wxT("suffix"), wxEmptyString), wxT(";"));
	if (! g_LibInfo.node.HasProp(wxT("list")))
	{
		return TPI_ERROR_ARC_UNSUPPORTED;
	}

	for (size_t i = 0; i < asExt.GetCount(); i++)
	{
		// .tar.XXXȂǓdւ̑ΉB
//		if (asExt[i].IsSameAs(fnArchive.GetExt(), false))
		if (fnArchive.GetFullName().EndsWith(wxT('.') + asExt[i]))
		{
			// JĊmFBsăf[^擾ĂB
			int nErrorCode = OpenArchive(_szArcName, NULL);

			// ΉB
			if (_nFileCount != NULL)
			{
				// t@C͑߂ɎĂB
				* _nFileCount = g_asOutput.Count();
			}
			return nErrorCode;
		}
	}

	return TPI_ERROR_ARC_UNSUPPORTED;
}

int __stdcall OpenArchive
(
	const wxString & _szArcName,
	void * * _hArchive
)
{
	if (g_szCurrentArchive != _szArcName)
	{
		wxString szOutput;
		if (myExecute(g_LibInfo.szExeFile + wxT(" ") + MakeCommandLineSend(g_LibInfo.node.GetPropVal(wxT("list"), wxEmptyString), _szArcName, NULL, NULL, wxEmptyString), & szOutput, wxEmptyString) != TPI_ERROR_SUCCESS)
		{
			return TPI_ERROR_U_USE_LIBRARY;
		}
		g_szCurrentArchive = _szArcName;
		g_asOutput = ::wxStringTokenize(szOutput, wxT("\r\n"));
	}
	if (_hArchive != NULL)
	{
		* _hArchive = & g_asOutput;
	}
	return g_asOutput.Count() == 0 ? TPI_ERROR_UNDEFINED : TPI_ERROR_SUCCESS;
}

int __stdcall CloseArchive
(
	void * _hArchive
)
{
	((wxArrayString *) _hArchive)->Clear();
	return TPI_ERROR_SUCCESS;
}

int __stdcall GetFileInformation
(
	void * _hArchive,
	TPI_FILEINFO * _fiInfo,
	bool _bFirst
)
{
	static size_t s_uCurrentLine;
	static wxULongLong s_llFileID;
	if (_hArchive == NULL)
	{
		return TPI_ERROR_UNDEFINED;
	}
	wxArrayString asOutput = * (wxArrayString *) _hArchive;

	// XML̓ǂݍ݂͏ɍsB
	static wxString szEndLine, szDateFormat;
	static unsigned long nProcessPerLine;
	static PosInfo piFName, piPSize, piUSize, piDate;
	if (_bFirst)
	{
		s_llFileID = 0;
		wxString szStartLine = g_LibInfo.node.GetPropVal(wxT("list-line-s"), wxEmptyString);
		if (! szStartLine.IsEmpty())
		{
			// Jns̎̍sɃZbgB
			s_uCurrentLine = asOutput.Index(szStartLine) + 1;
			if (s_uCurrentLine == wxNOT_FOUND + 1)
			{
				// ɂǂݍ߂ȂH
				return TPI_ERROR_ARC_UNSUPPORTED;
			}
		}

		// ݒB
		g_LibInfo.node.GetPropVal(wxT("list-line-c"), wxT("1")).ToULong(& nProcessPerLine);
		szEndLine = g_LibInfo.node.GetPropVal(wxT("list-line-e"), szStartLine);
		szDateFormat = g_LibInfo.node.GetPropVal(wxT("list-date-f"), wxDefaultDateTimeFormat);
		piFName = MakePosInfo(wxT("fname"));
		piPSize = MakePosInfo(wxT("psize"));
		piUSize = MakePosInfo(wxT("usize"));
		piDate = MakePosInfo(wxT("date"));
	}

	if (s_uCurrentLine >= asOutput.Count())
	{
		// ɂǂݍ߂ȂH
		return TPI_ERROR_ARC_UNSUPPORTED;
	}

	// ŏIsǂmFB
	if (asOutput[s_uCurrentLine] == szEndLine)
	{
		return TPI_ERROR_S_ENDOFDATA;
	}

	// t@C擾B
	_fiInfo->szStoredName = piFName.nCount == 0 ? asOutput[s_uCurrentLine + piFName.nLine].Mid(piFName.nStart) : asOutput[s_uCurrentLine + piFName.nLine].Mid(piFName.nStart, piFName.nCount);
	_fiInfo->szStoredName.Trim();
	_fiInfo->fnFileName = wxFileName::wxFileName(_fiInfo->szStoredName);

	// TCY擾B
	_fiInfo->llPackedSize   = GetSize(piPSize, s_uCurrentLine, asOutput);
	_fiInfo->llUnpackedSize = GetSize(piUSize, s_uCurrentLine, asOutput);

	// XV擾B
	if (piDate.nStart != 0 || piDate.nCount != 0)
	{
		_fiInfo->tmModified.ParseFormat(piDate.nCount == 0 ? asOutput[s_uCurrentLine + piDate.nLine].Mid(piDate.nStart) : asOutput[s_uCurrentLine + piDate.nLine].Mid(piDate.nStart, piDate.nCount), szDateFormat);
	}

	// ŌɎ̍s֐i߂ĂB
	_fiInfo->llFileID = s_llFileID++;
	s_uCurrentLine += nProcessPerLine;

	return TPI_ERROR_SUCCESS;
}

int __stdcall GetArchiveInformation
(
	void *,
	TPI_ARCHIVEINFO * _aiInfo
)
{
	// `Ɋւ擾B
	MakeFormatInfo(wxT("cuiWrapper"), & _aiInfo->fiInfo, & g_LibInfo.node, 0);
	return TPI_ERROR_SUCCESS;
}

int __stdcall Command
(
	unsigned int _uCommand,
	TPI_SWITCHES * _swInfo,
	const wxString & _szArcName,
	const wxArrayString & _szFiles
)
{
	// xmlR}hC擾B
	wxString szPath, szCommandLine;

	// APIAhX擾B
	if (! g_LibInfo.node.GetPropVal(
			_uCommand == TPI_COMMAND_ADD     ? wxT("add") :
			_uCommand == TPI_COMMAND_EXTRACT ? wxT("extract") : 
			_uCommand == TPI_COMMAND_DELETE  ? wxT("delete") : 
			_uCommand == TPI_COMMAND_UPDATE  ? wxT("update") : 
			_uCommand == TPI_COMMAND_TEST    ? wxT("test") : 
			_uCommand == TPI_COMMAND_REPAIR  ? wxT("repair") : 
			_uCommand == TPI_COMMAND_MOVE    ? wxT("move") : 
			_uCommand == TPI_COMMAND_SFX     ? wxT("sfx") : 
			_uCommand == TPI_COMMAND_UNSFX   ? wxT("unsfx") : wxEmptyString, & szCommandLine))
	{
		g_LibInfo.node.GetPropVal(
			_uCommand == TPI_COMMAND_ADD     ? wxT("add-alt") :
			_uCommand == TPI_COMMAND_EXTRACT ? wxT("extract-alt") : 
			_uCommand == TPI_COMMAND_DELETE  ? wxT("delete-alt") : 
			_uCommand == TPI_COMMAND_UPDATE  ? wxT("update-alt") : 
			_uCommand == TPI_COMMAND_TEST    ? wxT("test-alt") : 
			_uCommand == TPI_COMMAND_REPAIR  ? wxT("repair-alt") : 
			_uCommand == TPI_COMMAND_MOVE    ? wxT("move-alt") : 
			_uCommand == TPI_COMMAND_SFX     ? wxT("sfx-alt") : 
			_uCommand == TPI_COMMAND_UNSFX   ? wxT("unsfx-alt") : wxEmptyString, & szCommandLine);
	}

	if (szCommandLine.IsEmpty())
	{
		return TPI_ERROR_U_USE_LIBRARY;
	}

	// R}hCEX|Xt@C쐬B
	wxString
		szResponceFileName = MakeResponceFile(_szFiles, g_LibInfo.node.GetPropVal(wxT("quote-resp"), wxT("1")) == wxT("1")),
		szCommandLineSend  = MakeCommandLineSend(szCommandLine, _szArcName, _swInfo, _szFiles, szResponceFileName);

	// R}hCsB
	wxString szOutput;
	DWORD nErrorCode = myExecute(g_LibInfo.szExeFile + wxT(" ") + szCommandLineSend, & szOutput, _swInfo->fnDestinationDirectory.GetFullPath());

	// X|Xt@C폜B
	::wxRemoveFile(szResponceFileName);

	if (nErrorCode != TPI_ERROR_SUCCESS)
	{
#ifdef __LINUX__
		::wxMessageBox(wxString::Format(wxT("Error :\n%d\n\nCommandLine:\n%s\n\nOutput:\n%s"), nErrorCode, szCommandLineSend.c_str(), szOutput.c_str()));
#else
		MessageBox(NULL, wxString::Format(wxT("Error :\n%d\n\nCommandLine:\n%s\n\nOutput:\n%s"), nErrorCode, szCommandLineSend.c_str(), szOutput.c_str()), NULL, 0);
#endif
	}
	return nErrorCode;
}

int __stdcall SetCallbackProc
(
	TPI_PROC _prArcProc
)
{
	// |C^ۑB
	if (_prArcProc == NULL)
	{
		return TPI_ERROR_D_PARAMETER;
	}
	g_prProc = * _prArcProc;

	return TPI_ERROR_SUCCESS;
}

#ifdef __cplusplus
}
#endif
