/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  
 */


#define _MACRO_ONLY

/*
 *	J[lp̃X^[gAbvW[iBLACKfinpj
 */
 
#include "jsp_kernel.h"
 


			// ݁AO̖߂NGXgO
#define RETURNREQ 0xf

			// 32bit WX^ɑl[h}N
#ifdef __GNUC__
#define LOADLABEL( reg, value32 ) reg##.h = value32; reg##.l = value32;
#define LOADVALUE( reg, value32 ) reg##.h = ( value32 >> 16 ) &0xFFFF; reg##.l = value32 & 0xFFFF;
#elif defined(__ECC__)
#define LOADVALUE( reg, value32 ) reg##.h = hi(value32); reg##.l = lo(value32);
#define LOADLABEL LOADVALUE
#else
#error "Compiler is not supported"
#endif


#ifdef __GNUC__
#include "cdef_LPBlackfin.h"		/* gnu tool chain */
#elif defined(__ECC__)
#include <cdef_lpblackfin.h>	/* VisualDSP++ */
#else
#error "Compiler is not supported"
#endif

#include "saverestore.h"


#ifdef __GNUC__
.section .init;
.extern _boot_for_gdb;
.extern __bss_start, __bss_end;
#elif defined(__ECC__)
.section program;
#else
#error "Compiler is not supported"
#endif

.global start;
.extern _exc_vector;
.extern ldf_stack_end;
.extern _kernel_start;
.extern _reqflg;

#ifdef USE_RUNTIME_INIT
.extern _mi_initialize;
#endif

start:
	R0 = 0;
	LC0 = R0;
	LC1 = R0;
	L0 = R0;
	L1 = R0;
	L2 = R0;
	L3 = R0;
    LOADLABEL( p0, ldf_stack_end )
    sp = p0;
#ifdef __GNUC__                 // bss̈̏
    LOADLABEL( r0, __bss_start) // bssJnԒn
    LOADLABEL( r1, __bss_end )
    r2 = r1 - r0;            // bss̃TCY
    p0 = r0;                // JnAhX
    p2 = r2;
    r0 = 0;
    loop bssfill lc0 = p2; 
loop_begin bssfill
        b[p0++] = r0;
loop_end bssfill;

    sp += -12;
    call _boot_for_gdb;     // gdbŃ[hƂɃZbgmɂ邽߂̃R[h
    sp += 12;
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif

#ifdef USE_RUNTIME_INIT			// board_config.h Q
	sp += -12;
	call _mi_initialize;		// e[u
	sp += 12;
	cc = r0;					// Ԃl`FbN
invalid : 
	if cc jump invalid; 		// 0ȂG[
#endif
					// TOPPERS/JSP for BLACKfin emu,rst,nmiǗȂ
	LOADVALUE( p0,EVT0+2*4)	// NMIxNg
	p1 = 4;


	LOADLABEL( r0, nmiEntry )		// NMI
	[p0++p1] = r0;

	LOADLABEL( r0, expEntry)		// EXP
	[p0++p1] = r0;

	p0 = p0+p1;					// \̈XLbv

	LOADLABEL( r0, ivHWEntry)		// n[hEFAG[
	[p0++p1] = r0;

	LOADLABEL( r0, ivTMREntry)		// ^C}[
	[p0++p1] = r0;

	LOADLABEL( r0, ivg7Entry)		// IVG7
	[p0++p1] = r0;

	LOADLABEL( r0, ivg8Entry)		// IVG8
	r0.H = ivg8Entry;
	[p0++p1] = r0;

	LOADLABEL( r0, ivg9Entry)		// IVG9
	[p0++p1] = r0;

	LOADLABEL( r0, ivg10Entry)		// IVG10
	[p0++p1] = r0;

	LOADLABEL( r0, ivg11Entry)		// IVG11
	[p0++p1] = r0;

	LOADLABEL( r0, ivg12Entry)		// IVG12
	[p0++p1] = r0;

	LOADLABEL( r0, ivg13Entry)		// IVG13
	[p0++p1] = r0;

	LOADLABEL( r0, ivg14Entry)		// IVG14
	[p0++p1] = r0;

	LOADLABEL( r0, task_level)		// IVG15̓^XNɑJڂ邽߂̃Gg[
	[p0++p1] = r0;
	
	LOADLABEL( p2, user)				// _~[̖߂Ԓnݒ
	reti = p2;
	csync;
	raise	15;					// IVG15𐶋NB荞݂͒xB
	
	r0 = 0xC01F(z);				// IVG15t\(CPUbN)
	sti r0;
	csync;
	rti;						// [U[[h֑Jڂ
	
task_level:                     // ^XN̎s
    r0 = syscfg;
    r1 = 0x4;                   // ZtElXeBO
    r0 = r0 | r1;
    syscfg = r0;                // ZtElXgL

    sp += -12;
#ifdef __GNUC__					/* GCC */
#elif defined(__ECC__)			/* VisualDSP++ */
#ifdef INIT_C_PLUS_PLUS
    r0 = 0;
    r1 = 0;
    call.x ___ctorloop;
#endif
#else
#error "Compiler is not supported"
#endif

    [--sp] = reti;				// ߂Ԓn̂ĂĊ荞݉\ɂ
    jump.x _kernel_start;			// kernel_stgart()͖߂ĂȂ
user:
	jump	user;
start.end:




#ifdef __GNUC__
.section .text;
#elif defined(__ECC__)
.section program;
#else
#error "Compiler is not supported"
#endif

.extern interrupt_dispatcher;
.extern task_context;

/*
*	ÕGg
*
*	荞݂Ƃ̃lXg֌W𒲂ׁAlXgĂȂȂCxgX^bNZbgB
*		p0 : [U[`̗Onh̃AhX
*		p1 : IPEND̃AhX
*		p2 : reqflg̃AhX
*		r6 : ^XNX^bN
*		r7 : ASTAT̑ޔ
*
*/
expEntry:
	[--sp] = p0;	
	save_regs;					// [U[WX^̑ޔ

	LOADLABEL( p0, _exc_vector)		// [U[`Onh̊i[AhX
	LOADVALUE( p1, IPEND )			// IPENDWX^̃AhX

	l0 = r0;
	l1 = r0;
	l2 = r0;
	l3 = r0;
	lc0 = r0;					// \ቺ}̂߂LCxNA
	lc1 = r0;

	p0 = [p0];					// p0 = exc_vector	
	r0 = [p1];					// IPEND̒l擾
	r1 = 0x7fef;				// 
	r0 = r0 & r1;				// IVG15GIDȊO𒲂ׂ. r0.H͕K0
	r0.L = ones r0;				// ̃Cxg̐𐔂
	r0 += -1;					// Cxg̐-1BlXgĂȂ0ɂȂB
	cc = r0 == 0;				// lXgĂȂΐ^
	if !cc jump call_exception; // lXgĂ΃nhĂ
								// lXgĂȂCxgȂAX^bN؂ւ
	r6 = sp;					// ^XNX^bN|C^ޔ
	LOADLABEL( r0, ldf_stack_end)	// CxgX^bN|C^ݒ
	sp = r0;
	
call_exception:
	r7 = astat;					// ccɂ̓lXg񂪓ĂBޔ
	r0 = p1;					// IPEND̃AhX
	sp += -12;					// _~[̈m (E)
	call	(p0);				// CŏꂽOnhĂ
	sp += 12;					// _~[̈J (E)
	astat = r7;					// cc𕜋A
	if !cc jump get_back_x;		// lXgĂȂ΁Â܂܋A
	
								// ł̓Cxg̓lXgĂȂ
	sp = r6;					// X^bN^XNX^bNɐݒ

	LOADLABEL( p2, _reqflg )
	r0 = [p2];					// reqflg̒l擾
	cc = r0;					// fBXpb`^XNO̗v͏oĂ邩
	if !cc jump get_back_x;		// oĂȂȂΊ荞܂ꂽ^XNɖ߂

								// ReLXg؂ւƊJn
	r0 = 0;						// 
	[p2] = r0;					// reqflgNA.
	r0 = retx;					// ^XN̖߂Ԓno
	r1 = 1;
	r0 = r1 | r0; 				// ZtElXgłƋU
	[--sp] = r0;				// ߂ԒnX^bNɂ
	LOADLABEL( p0, task_context)
	
	cli r0;						// ݂CPUbNԂ擾
	[--sp] = r0;				// bNԂޔ
	r1 = 0xC01F(z);				// ^XNReLXg͂CPUbNԂŎs
	
#ifdef UNMANAGED_INT
    r2 = UNMANAGED_INT(z);
    r0 = r0 & r2;				// ǗO荞݂̃}XNԂ𒊏o
    r1 = r0 | r1;				// ^XNReLXgCPUbNԂŎs
#endif
	sti r1;						// CPUbN (F)
	
	retx = p0;					// x"taskiv_context"O̖߂Ԓnɂ
	rtx;						// O߂BReLXg̓^XNɂȂ
	
get_back_x:	
	restore_regs;				// ޔWX^SĖ߂
	p0=[sp++];
	rtx;
expEntry.end:

// Cxgnh̃Gg[R[hQB
// EVT̃Ggɂ͑Ήȉ̃R[h̃xi[B
// ꂼ̃R[h̓Cxgɂp0Ɋi[A
// interrupt_dispatcherɃWv
// evtvector̓[U[nhւ̃|C^̔z




ivHWEntry:
	[--sp] = p0;
	p0 = 5;
	jump.x interrupt_dispatcher;
ivHWEntry.end:

ivTMREntry:
	[--sp] = p0;
	p0 = 6;
	jump.x interrupt_dispatcher;
ivTMREntry.end:

ivg7Entry:
	[--sp] = p0;
	p0 = 7;
	jump.x interrupt_dispatcher;
ivg7Entry.end:

ivg8Entry:
	[--sp] = p0;
	p0 = 8;
	jump.x interrupt_dispatcher;
ivg8Entry.end:

ivg9Entry:
	[--sp] = p0;
	p0 = 9;
	jump.x interrupt_dispatcher;
ivg9Entry.end:

ivg10Entry:
	[--sp] = p0;
	p0 = 10;
	jump.x interrupt_dispatcher;
ivg10Entry.end:

ivg11Entry:
	[--sp] = p0;
	p0 = 11;
	jump.x interrupt_dispatcher;
ivg11Entry.end:

ivg12Entry:
	[--sp] = p0;
	p0 = 12;
	jump.x interrupt_dispatcher;
ivg12Entry.end:

ivg13Entry:
	[--sp] = p0;
	p0 = 13;
	jump.x interrupt_dispatcher;
ivg13Entry.end:

ivg14Entry:					// dispatch()̊荞ݑ҂
#if !defined(USE_TIC_CORE) && !defined(USE_HW_ERROR)
	csync;						// RA^C}[ŃeBbNނƂɂidle߂gȂB
	idle;						// Cxg҂
	csync;
#endif
	[--sp] = reti;				// ݃lXg
	r1 = 0xffff(z);				// CPU AbNpp^[
#ifdef UNMANAGED_INT
    cli r0;               // ݂̃}XNo
	r2 = UNMANAGED_INT(z);
	r0 = r0 & r2;				// ǗO荞݂̂ݎo
	r2 = ~r2;					// t}XN
	r1 = r1 & r2;				// 
	r1 = r1 | r0;				// ǗO荞݂l}XN
#endif
	sti r1;						// CPU AbN
	r1 = 0xC01F(z);				// CPU bNpp^[
    cli r0;               // ݂̃}XNo
                                // ǗO荞݂gȂꍇAی̂ߕKv
#ifdef UNMANAGED_INT
	r2 = UNMANAGED_INT(z);
	r0 = r0 & r2;				// ǗO荞݂̂ݎo
	r1 = r1 | r0;				// ǗO荞݂l}XN
#endif
	sti r1;
	reti=[sp++];				// ݃lXg֎~
	rti;
ivg14Entry.end:




nmiEntry:
	jump	nmiEntry;
	rtn;
nmiEntry.end:	




#ifdef __GNUC__
#elif defined(__ECC__)

#ifdef INIT_C_PLUS_PLUS
.section ctor;
	.align 4;
___ctor_table:
	.byte4=0;
.global ___ctor_table;
.type ___ctor_table,STT_OBJECT;
.extern ___ctorloop;
.section .gdt;
        .align 4;
___eh_gdt:
.global ___eh_gdt;
        .byte4=0;
.type ___eh_gdt,STT_OBJECT;
.section .frt;
        .align 4;
___eh_frt:
.global ___eh_frt;
        .byte4=0;
.type ___eh_frt,STT_OBJECT;
#endif  /* INIT_C_PLUS_PLUS */

#else
#error "Compiler is not supported"
#endif

