/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  TOPPERS/JSP for Blackfin
 *
 *  Copyright (C) 2004,2006,2006 by Takemasa Nakamura
 *  Copyright (C) 2004 by Ujinosuke
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  
 */

/*
 *	^[QbgVXeˑW[iADSP-BF537pj
 */

#include "jsp_kernel.h"
#include <sil.h>

#ifdef __GNUC__
#include "../cdefBF537.h"		/* gnu tool chain */
#elif defined(__ECC__)
#include <cdefBF53x.h>				/* VisualDSP++ */
#include <sys/exception.h>
#include <ccblkfn.h>
#include <sysreg.h>
#else
#error "Compiler is not supported"
#endif

/*
*  荞݃vCIeB錾
*/
#ifdef __GNUC__
#ifndef ik_ivtimer
#define ik_timer 6
#endif
#elif defined(__ECC__)
#else
#error "Compiler is not supported"
#endif



/*
 *  ^[QbgVXeˑ̏
 */
void
sys_initialize()
{

	/*
	 *  PLL̐ݒ
	 *
	 */
	/*
	 *  SSELVAL, CSELVALboard_config.hɂĒ`B
	 */
	*pSIC_IWR = IWR_ENABLE(0);				// PLL̂IWR
#if CSELVAL == 1 
	*pPLL_DIV = CSEL_DIV1 | SET_SSEL(SSELVAL);
#elif CSELVAL == 2
	*pPLL_DIV = CSEL_DIV2 | SET_SSEL(SSELVAL);
#elif CSELVAL == 4
	*pPLL_DIV = CSEL_DIV4 | SET_SSEL(SSELVAL);
#elif CSELVAL == 8
	*pPLL_DIV = CSEL_DIV8 | SET_SSEL(SSELVAL);
#else
#error Wrong CSELVAL. Must be one of 1,2,4,8.
#endif
	
	*pPLL_CTL = MSELVAL << 9;
		
	asm("cli r0; csync; idle; sti r0;": : :"R0");
	*pSIC_IWR = IWR_ENABLE_ALL;


}

        // priority_masḱAevent0..15ɉ
        // 荞ݗṽrbg}bvێB
unsigned int priority_mask[16]={
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000000,
0x00000007,
0x00000018,
0x000001E0,
0x00007E00,
0x00078000,
0x1FF80000,
0xE0000000,
0x00000000,
0x00000000
};


/*
* SIC_IARx͂āACxgʂƂɊ蓖ĂĂ銄荞
* ̃rbg}bvBSIC_IARx̃tB[hl͗D揇-7Ȃ̂
* ̕␳B
*/
#define INSTALL_PRIORITY    \
    for ( i=0; i<8; i++ ){ \
        priority = iar & 0xf;                         /* IARD揇ʂo */ \
        priority_mask[priority + 7] |= device;        /* oD揇ʂɊÂfoCXo^ */ \
        device <<= 1;                                 /* ̃foCX */ \
        iar >>= 4;                                    /* IARtB[h */ \
    }

void make_priority_mask( void )
{
	unsigned int i, priority, device, iar;
	
	
	/*
 *  荞ݏʂƂISRrbg}bv̍쐬
 *  SIC_IARx̐ݒ͂̕Oɍς܂邱
 */
 
        // priority_masḱAevent0..15ɉ
        // 荞ݗṽrbg}bvێB
 	for ( i=0; i<16; i++ ){
 		priority_mask[i] = 0;
 	}
 
	device = 1;
	iar = *pSIC_IAR0;
	INSTALL_PRIORITY

	iar = *pSIC_IAR1;
    INSTALL_PRIORITY
	
	iar = *pSIC_IAR2;
    INSTALL_PRIORITY
	
    iar = *pSIC_IAR3;
    INSTALL_PRIORITY
	
}


/*
 * 荞݂̋A֎~
 *
 */
ER ena_int( INTNO intno )
{
	unsigned int mask;
	
	if ( intno >= DEVICE_INTERRUPT_COUNT )
		return ( E_PAR );
	else {
		mask = 1 << intno;
		*pSIC_IMASK |= mask;
		return (0);
	}
}
ER dis_int( INTNO intno )
{
	unsigned int mask;

	if ( intno > INTNO_WDG )
		return ( E_PAR );
	else {
		mask = 1 << intno;
		mask = ~mask;
		*pSIC_IMASK &= mask;
		return (0);
	}
}

/*
 * 荞݃}XN̑
 *
 *
 */
ER chg_ims( IMS ims )
{
	*pSIC_IMASK = ims;
	return( 0 );
}

extern ER get_ims( IMS * p_ims )
{
	*p_ims = *pSIC_IMASK;
	return( 0 );;
}


/*
 *  荞݂foCXɊ蓖Ă
 */
void device_dispatcher( unsigned int priority )
{
	unsigned int candidates, device;
	
	candidates = priority_mask[priority] & *pSIC_ISR & *pSIC_IMASK;	// ݂̃vCIeBɑ銄݌肷

	if ( ! candidates ) // 荞݌łȂȂARARł
	{
#ifdef USE_HW_ERROR
		if ( priority == ik_hardware_err)
			dev_vector[INHNO_HW_ERROR]();
		else 
#endif
			if ( priority == ik_timer)
			dev_vector[INHNO_TIMER]();
		else
			dev_vector[INHNO_RAISE]();		//@\tgEFA荞

	}
	else 
	{
		if ( candidates & 0x80000000 )
			device = 31;
		else
		{
#ifdef __GNUC__
	asm ( "r1.L = signbits %1; %0 = r1.L(z);":"=d"(device) :"d"(candidates): "R1"  );
#elif defined(__ECC__)
	asm( "%0 = signbits %1;" : "=l"( device ) : "d"( candidates ) );
#else
#error "Compiler is not supported"
#endif
			device = 30 - device;		// bit mask is converted to bit number
		}
		dev_vector[device]();
	}
}



/*
 *  ^[QbgVXȅI
 */
void
sys_exit()
{
	while(1)
		;
}

/*
 *  ^[QbgVXe̕o
 */
void
sys_putc(char c)
{
}



