<?php
//include_once('config_auth.ini.php');	// 設定用ファイル

// http://auth.livedoor.com/login/?app_key=<app_key>&perms=<perms>&t=<time>&v=1.0&userdata=<userdata>&sig=<sig>
class AuthLiveDoor {

	const LIVEDOOR_AUTH_PORT = 80;		// ポート
	const LIVEDOOR_AUTH_TIMEOUT  = 10;	// タイムアウト
	const LIVEDOOR_AUTH_VERSION  = '1.0';	// 認証APIのプロトコルバージョン
	const LIVEDOOR_AUTH_PERMS  = 'id';	// 認証APIのアクセス権
	const LIVEDOOR_AUTH_FORMAT  = 'xml';	// 認証APIの取得フォーマット
	const LIVEDOOR_AUTHURL = "auth.livedoor.com";	// LiveDoor認証URL

	private $login_state = false;
	private $login_id = "";
	private $err_msg = "";

	private $apikey = "";
	private $secret = "";

	public function __construct($apikey, $secret) {
		$this->apikey = $apikey;
		$this->secret = $secret;
	}

	// 
	// $cert = $_GET['token'];
    public function getAuth($token) {
		if (!JUGEM_AUTHFLG) {
			return;
		}

		if ($token == "" ) {
			return;
		}

		$api_time = date('U');	// エポック秒で
		$param_ary = array('app_key' => urlencode($this->apikey)
						,'format' => urlencode(AuthLiveDoor::LIVEDOOR_AUTH_FORMAT)
						,'token' => urlencode($token)
						,'t' => urlencode($api_time)
						,'v' =>  urlencode(AuthLiveDoor::LIVEDOOR_AUTH_VERSION)
						);
		ksort($param_ary);
		$api_sig = "";
		foreach ($param_ary as $key => $value) {
			$api_sig .= $key.$value;
		}
		$api_sig = hash_hmac('sha1',$api_sig,$this->secret);

		$param = "app_key=".urlencode($this->apikey)
			."&format=".urlencode(AuthLiveDoor::LIVEDOOR_AUTH_FORMAT)
			."&token=".urlencode($token)
			."&t=".urlencode($api_time)
			."&v=".urlencode(AuthLiveDoor::LIVEDOOR_AUTH_VERSION)
			."&sig=".urlencode($api_sig);

		$fp = fsockopen(AuthLiveDoor::LIVEDOOR_AUTHURL
				, AuthLiveDoor::LIVEDOOR_AUTH_PORT
				, $errno
				, $errstr
				, AuthLiveDoor::LIVEDOOR_AUTH_TIMEOUT);
		if (!$fp) {
			$this->err_msg = "$errstr ($errno)<br />\n";
		} else {
			$out = "POST /rpc/auth HTTP/1.1\r\n";
			$out .= "Host: auth.livedoor.com\r\n";
			$out .= "Content-Type: application/x-www-form-urlencoded\r\n";
			$out .= "Content-Length: ".strlen($param)."\r\n";
			$out .= "Connection: Close\r\n\r\n";
			$out .= "$param";

			fwrite($fp, $out);
			$ret = "";
			while (!feof($fp)) {
				$ret .= fgets($fp, 2048);
			}
			fclose($fp);
		}

		// LiveDoorの認証XMLのパターン
		$pattern = '/(\s*<livedoor_id>)(.*)(<\/livedoor_id>)/';
		preg_match_all($pattern,$ret,$getAry);
		$livedooruserid = "";
		if (isset($getAry[2][0])) {
			$livedooruserid = $getAry[2][0];
		} 

		// ユーザーIDを取得できた場合
		if ($livedooruserid != "") {
			// ログイン成功
			$this->login_state = true;
			$this->login_id = LIVEDOOR_SERVICEID . $livedooruserid;
			return true;
		} else {
			return false;
		} 
	}

	public function getLoginState(){
		return $this->login_state;
	}

	public function getErrorMsg(){
		return $this->err_msg;
	}

	public function getLoginId(){
		return $this->login_id;
	}

	public function getLoginUrl() {
		$api_time = date('U');
		$param_ary = array('app_key' => $this->apikey
						,'perms' => AuthLiveDoor::LIVEDOOR_AUTH_PERMS
						,'t' => $api_time
						,'v' =>  AuthLiveDoor::LIVEDOOR_AUTH_VERSION
//						,'userdata' => data
						);
		ksort($param_ary);		// どうやらKeyでソートらしい
		$api_sig = "";
		foreach ($param_ary as $key => $value) {
			$api_sig .= $key.$value;
		}
		$api_sig = hash_hmac('sha1',$api_sig,$this->secret);

		$loginurl = "http://auth.livedoor.com/login/"
			."?app_key=".$this->apikey
			."&perms=".AuthLiveDoor::LIVEDOOR_AUTH_PERMS
			."&t=".$api_time
			."&v=".AuthLiveDoor::LIVEDOOR_AUTH_VERSION
//			."&userdata="
			."&sig=".$api_sig;

		return $loginurl;
	}


}
