<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/user.class.php');
	require_once(TODOTASK_CTRL_DIR.'/email.class.php');

	// ページロード
	$page = gfPageLoad();

	$page->title = TITLE_USERMST;
	$page->mode = gfIssetGET('mode',USER_CLASS_INS); 		// 画面呼び出しモード
	$page->setmode = "";						// 更新モード用 
	$page->csrf = gfIssetPOST('csrf',""); 	 	// CSRF対策
	$page->group_no = gfIssetPOST('grpid',"");	// 削除用グループ番号

	$page->contxt = array(
		'newid'=>gfIssetPOST('id',""), 
		'newname'=>gfIssetPOST('name',""), 
		'user_pass'=>gfIssetPOST('pass',""), 
		'user_mail'=>gfIssetPOST('mail',""), 
		'user_note'=>gfIssetPOST('note',""), 
		'qword'=>gfIssetPOST('qword',""), 
		);

	// check page parameter
	$page->chkPage();

	// ログイン状態取得
	$objUser = new User();
	$objMail = new EMail();

	// 新規登録
	if ($page->mode == USER_CLASS_INS) {
		// ログイン状態解除
		$objUser->UnsetLogin();

		// 入力情報の確認
		$page->art_msg = fCheckInputForm($page,$objUser,false);
		// 警告が発生しなかった場合
		if ($page->art_msg == "") {
			$page->art_msg = fUserIns($page,$objUser,$objMail);
		}
	// 更新モードの設定
	} else {
		$page->user_name = $objUser->get_loginname(); 
		$page->user_id = $objUser->get_loginid(); 

		// ログイン状態の確認
		if (!$objUser->ChkLogin()) {
			$objUser->ctrl_movepage("userlogin.php");
		}
		// ユーザ情報の取得
		$page->aryUser = $objUser->GetUserMst($page->user_id);
		if (!isset($page->aryUser["user_pass"])) {
			$objUser->ctrl_movepage("userlogin.php");
		}
	
		// ユーザ所属グループ情報の取得
		$page->aryUserGrp = $objUser->GetUserMemGrp($page->user_id);
	
		// 入力情報の確認
		if ($page->mode == USER_CLASS_UPDACT) {
			$page->art_msg = fCheckInputForm($page,$objUser,true);
		}
		if ($page->mode == USER_CLASS_UPD) {
			$page->contxt['newname'] = $page->aryUser['user_name']; 	
			$page->contxt['user_pass'] = $page->aryUser['user_pass']; 	
			$page->contxt['user_mail'] = $page->aryUser['user_mail']; 
			$page->contxt['user_note'] = $page->aryUser['user_note']; 
		}

		// 警告が発生しなかった場合
		if ($page->art_msg == "") {
			if ($page->mode == USER_CLASS_UPDACT) {
				$page->art_msg = fUserUpd($page ,$objUser);
			// ユーザー情報削除処理
			} elseif ($page->mode == USER_CLASS_DELACT) {
				fUserDel($page, $page->aryUserGrp ,$page->aryUser);
			// グループ脱退
			} elseif (($page->mode == USER_CLASS_MEMOUT)&&($page->group_no!="")) {
				$page->backurl = "./usermst.php?mode=upd";
				$page->art_msg = fMemOut($page, $page->group_no , $objUser);
			}
		}
	}

	// 更新モードの設定
	if ($page->mode == USER_CLASS_UPD || $page->mode == USER_CLASS_UPDACT) {
		$page->setmode = "?mode=".USER_CLASS_UPDACT;
	}

	// CSRFの発行
	$page->csrf = $objUser->get_csrf($page->user_id);

	$page->display('/user/mst.php');

	// ページ終了処理
	gfPageUnLoad();


// 入力チェック
function fCheckInputForm($page,$objUser,$updatemode = false) {
	$sMsg = "";
	$serviceid = false;		// serviceID

	// 外部認証APIを利用する場合
	if (!$objUser->ChkIDfmt($page->contxt['newid'])) {
		// IDにサービスIDが含まれている
		$serviceid = true;
	}

	// 入力内容のチェック
	if ($page->contxt['newid'] == "" || $page->contxt['newname'] == "") {
		$sMsg = USER_ART_007;
	} elseif (strlen($page->contxt['newid']) < MIN_IDLEN) {
		$sMsg = USER_ART_009;
	// 全角判定
	} elseif(!gfChkIDType($page->contxt['newid'])){
		$sMsg = USER_ART_010;
	// メールの形式確認
	} elseif ($page->contxt['user_mail'] != "" && !EMail::ChkMailAdr($page->contxt['user_mail'])) {
		$sMsg = USER_ART_012;
	}

	// メールアドレスの重複チェック
	if (!MAIL_DUPE) { 
		$aryMUser = $objUser->ChkUserMail($page->contxt['user_mail']);
		if (isset($aryMUser[0]["user_id"])){
			if ($aryMUser[0]["user_id"]!=$page->contxt['newid']) {
				$sMsg = USER_ART_021;
			}
		}
	}

	// 外部認証を利用しない
	if ($serviceid!=true) {
		if ($page->contxt['user_pass'] == "" ) {
			$sMsg = USER_ART_007;
		} elseif ($page->contxt['user_mail'] == "" && MAIL_NEED) {
			$sMsg = USER_ART_008;
		} elseif (strlen($page->contxt['user_pass']) < MIN_IDLEN) {
			$sMsg = USER_ART_009;
		} elseif (!gfChkIDType($page->contxt['user_pass'])){
			$sMsg = USER_ART_011;
		}
	} else {
		// 外部認証を利用しているときはパスワードは空欄
		if ($page->contxt['user_pass'] != "" ) {
			$sMsg = USER_ART_020;
			// 想定外ルート
			gfHackTryLog(__FILE__.__LINE__."fCheckInputForm");
		}		
	}

	// 新規登録でサービスIDがIDに含まれている
	if ($serviceid == true && $updatemode == false) {
		$sMsg = USER_ART_013;
	}

	if ($sMsg != "") {
		return $sMsg;
	} 

	// 登録情報変更呼び出し
	if ($page->mode == USER_CLASS_UPD) {
		$sMsg = USER_MSG_003;
	}
	// 合言葉を確認する必要がある場合
	if ((QWORD != "")&&(AWORD != $page->contxt['qword'])&&($page->mode == USER_CLASS_INS)) {
		$sMsg = USER_ART_005;
	}

	return $sMsg;
}

// 新規登録処理
function fUserIns($page,$objUser,$objMail) {
	// CSRFのチェック
	$objUser->chk_csrf($page,$page->csrf,"");
	// トランザクション発行
	$retIns = $objUser->begin_trans();
	// ユーザ情報登録
	$retIns = $objUser->InsUser(
		$page->contxt['newid'],
		$page->contxt['newname'],
		$page->contxt['user_pass'],
		$page->contxt['user_mail'],
		$page->contxt['user_note']);
	if ($retIns) {
		// 登録メールを送信する。
		$objMail->SendUserResist($page->contxt['user_mail'],
								$page->contxt['newid'],
								$page->contxt['newname'],
								$page->contxt['user_pass']);
		// メール承認を必要としない場合はオートログイン
		if (!MAIL_NEED) {
			if ($objUser->ChkLoginDB($page->contxt['newid'],$page->contxt['user_pass'])) {
				// コミット|ロールバック
				$objUser->commit_trans($retIns);
				$objUser->ctrl_movepage();
			} else {
				// コミット|ロールバック
				$objUser->commit_trans($retIns);
				$objUser->ctrl_movepage("userlogin.php");
			}
		} else {
			// コミット|ロールバック
			$objUser->commit_trans($retIns);
			gfMsgWindow($page ,MSG_MODE_NOTE ,USER_ART_006_1 ,USER_ART_006_2 ,$page->backurl ,MSG_NOR);
		}
	}
	// コミット|ロールバック
	$objUser->commit_trans($retIns);
	if (!$retIns) {
		$sMsg = $objUser->get_errmsg();
	}
	return $sMsg; 

}

// 更新処理
function fUserUpd($page,$objUser) {
	// CSRFのチェック
	$objUser->chk_csrf($page,$page->csrf ,$page->user_id);
	$sMsg = "";
	// トランザクション発行
	$retUpd = $objUser->begin_trans();
	// ユーザ情報の更新
	$retUpd = $objUser->UpdUserMst(
			$page->user_id,
			$page->contxt['newname'],
			$page->contxt['user_pass'],
			$page->contxt['user_mail'],
			$page->contxt['user_note']);
	if (!$retUpd) {
		$sMsg = $objUser->get_errmsg();
	}
	// コミット|ロールバック
	$objUser->commit_trans($retUpd);

	// パスワードが変更されているかもしれないので再ログイン
	if (!$objUser->ChkLoginDB($page->user_id,$page->contxt['user_pass'])) {
		$sMsg = $objUser->get_errmsg();
		gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , $sMsg ,$page->backurl ,MSG_NOR);
	} else {
		gfMsgWindow($page ,MSG_MODE_NOTE ,USER_ART_002_1 , USER_ART_002_2 ,$page->backurl ,MSG_NOR);

	}
	return $sMsg; 
}

// グループ脱退処理
function fMemOut($page,$grpid,$objUser) {
	$sMsg = "";
	// CSRFのチェック
	$objUser->chk_csrf($page,$page->csrf,$page->user_id);

	// トランザクション発行
	$retDel = $objUser->begin_trans();

	// ユーザー情報の更新処理
	$retDel = $objUser->DelMemOut($page->user_id,$grpid);
	if (!$retDel){
		$sMsg = $objUser->get_errmsg();
	}
	// コミット|ロールバック
	$objUser->commit_trans($retDel);

	if ($sMsg=="") {
		gfMsgWindow($page ,MSG_MODE_NOTE ,USER_ART_004_1 , USER_ART_004_2 ,$page->backurl ,MSG_NOR);
	}
	return $sMsg; 
}

// 削除処理
function fUserDel($page,$aryUserGrp,$objUser) {
	// CSRFのチェック
	$objUser->chk_csrf($page,$page->csrf,$page->user_id);
	// トランザクション発行
	$retDel = $objUser->begin_trans();

	// ユーザー情報の削除処理
	if (count($aryUserGrp) > 0) {
		// 所属グループの削除
		for( $i=0; $i < count($aryUserGrp); $i++ ) {
			if (!$objUser->DelMemOut($page->user_id,$aryUserGrp[$i]["group_no"])){
				$retDel = false;
				break;					
			}
		}
	}
	if ($retDel) {
		// ユーザ情報の削除
		$retDel = $objUser->DelUser($page->user_id);
	}
	// コミット|ロールバック
	$objUser->commit_trans($retDel);

	$objUser->UnsetLogin();
	// ログアウト
	$objUser->ctrl_movepage("userlogin.php");

	return true;
}



?>