<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/grp.class.php');
	require_once(TODOTASK_CTRL_DIR.'/email.class.php');

	// ページロード
	$page = gfPageLoad();
	$page->group_no = gfIssetGET('group_no',""); 

	// check page parameter
	$page->chkPage();

	// ログイン確認
	$objGrp = new Grp();
	$objMail = new EMail();

	$page->user_name = $objGrp->get_loginname(); 
	$page->user_id = $objGrp->get_loginid(); 
	$page->backurl = ROOT_URL;
	// ログイン状態の確認
	if (!$objGrp->ChkLogin()) {
		$objGrp->ctrl_movepage("userlogin.php");
	}

	// 取得したグループが存在するか確認
	if (!$objGrp->ChkGroupMst($page->group_no)) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_001_1 , TASK_ART_001_2 ,$page->backurl ,MSG_NOR);
	}
	$page->group_name = $objGrp->get_group_name($page->group_no); 


	// メンバーチェック(参照しようとしているタスクのメンバーに登録されているか)
	$page->memLv = $objGrp->ChkMember($page->group_no,$page->user_id);
	// メンバーに所属していなくてメンバーモードの場合
	if ($page->memLv >= GRPAUTH_NOAPP) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , GRP_MSG_016 ,$page->backurl ,MSG_NOR);
	}


	// 表示モードの取得
	$aryViewMode = $objGrp->GetViewMode($page->group_no);
	// 指定したグループの表示モードが取得できませんでした。
	if (!isset($aryViewMode['assent_flg'])) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_003_1 , TASK_ART_003_2 ,$page->backurl ,MSG_NOR);
	}
	
	// (管理者の承認が必要か)承認モード [0:必要/1:不必要]
	if ($aryViewMode['assent_flg']==NEED_ASSENT) {
		$assent_flg = GRPAUTH_NOAPP;
	} else {
		$assent_flg = GRPAUTH_MEM;
	}

	// トランザクション発行
	$retIns = $objGrp->begin_trans();
	if ($retIns) {
		$retIns = $objGrp->InsMemberTbl($page->group_no,$page->user_id,$page->user_name,$assent_flg); 
	}
	// メンバー登録処理
	if ($retIns) {
		// 承認が必要な場合タスク管理者にメールを飛ばして承認を求める
		if ($assent_flg == 0 ) {
			$aryGrpAdminMem = $objGrp->GetGrpAdminMember($page->group_no);
			foreach ($aryGrpAdminMem as $val) {
				if (isset($val['user_mail'])) {
					// メール送信
					$objMail->SendMemJoin(
						$val['user_mail'],
						$page->user_name,
						$page->group_no,
						$page->group_name);
				}
			}
			// コミット|ロールバック
			$objGrp->commit_trans($retIns);
			gfMsgWindow($page ,MSG_MODE_NOTE ,GRP_MSG_017_1 , GRP_MSG_017_3 ,$page->backurl ,MSG_NOR);
		} else {
			// コミット|ロールバック
			$objGrp->commit_trans($retIns);
			gfMsgWindow($page ,MSG_MODE_NOTE ,GRP_MSG_017_1 , GRP_MSG_017_2 ,$page->backurl ,MSG_NOR);
		}
	} else 	{
		// コミット|ロールバック
		$objGrp->commit_trans($retIns);
		gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , ERR_NO_MSG ,$page->backurl ,MSG_NOR);
	}

	// ページ終了処理
	gfPageUnLoad();

?>