<?php
require_once(TODOTASK_DIR.'/app/controllers/login.class.php');

// 画面呼び出し画面
define("USER_CLASS_INS" ,"ins");		// 新規作成 
define("USER_CLASS_UPD" ,"upd");		// 更新用呼び出し 
define("USER_CLASS_UPDACT" ,"updin");	// 更新用書き込み
define("USER_CLASS_DELACT" ,"delact");	// 削除用書き込み
define("USER_CLASS_MEMOUT" ,"memout");	// グループメンバー脱退

class User extends Login {
	function __construct( ){
		parent::__construct();
	}

	function __destruct(){

	}
	
	// ユーザー情報の取得
	public function GetUserMst($id) {
		$aryRes = array();

		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	user_name,";
		$sSQL = $sSQL."	user_pass,";
		$sSQL = $sSQL."	user_mail,";
		$sSQL = $sSQL."	user_state, ";
		$sSQL = $sSQL."	user_note ";
		$sSQL = $sSQL."From user_mst ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	user_id = ".gfQt($id);
	
		$rs = parent::get_rs($sSQL);
	
		$i=1;
		if($rs) {
			while( $row = parent::get_row($rs)){
				$aryRes["user_name"] = gfGetDBFields($row,"user_name"); 
				$aryRes["user_pass"] = gfGetDBFields($row,"user_pass"); 
				$aryRes["user_mail"] = gfGetDBFields($row,"user_mail"); 
				$aryRes["user_note"] = gfGetDBFields($row,"user_note"); 
				$aryRes["user_state"] = gfGetDBFields($row,"user_state"); 
				$aryRes["user_cnt"] = $i; 
				$i++;
			}
			parent::free_rs($rs);
		}
		return $aryRes;

	}
	
	// ユーザのタスクグループ参加情報の取得
	public function GetUserMemGrp($id) {
		$aryRes = array();
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	mt.group_no group_no,";
		$sSQL = $sSQL."	gm.group_name group_name,";
		$sSQL = $sSQL."	mt.status status ";
		$sSQL = $sSQL."From member_tbl mt,group_mst gm ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	mt.group_no = gm.group_no ";
		$sSQL = $sSQL."	and mt.user_id = ".gfQt($id);
		$sSQL = $sSQL." Order By ";
		$sSQL = $sSQL."	mt.group_no ";


		$rs = parent::get_rs($sSQL);
	
		$i = 0;
		if($rs) {
			while( $row = parent::get_row($rs)){
				$aryRes[$i]["group_no"] = gfGetDBFields($row,"group_no"); 
				$aryRes[$i]["group_name"] = gfGetDBFields($row,"group_name"); 
				$aryRes[$i]["status_name"] = self::GetGrpAuthStatus(gfGetDBFields($row,"status"));
				$aryRes[$i]["status"] = gfGetDBFields($row,"status");
				$i++;
			}
			parent::free_rs($rs);
		}
		return $aryRes;
	}

	// ステータス状態の名称取得
	private function GetGrpAuthStatus($status_cd) {
		switch($status_cd){
			case GRPAUTH_ADMIN:
				$status = GRPAUTH_ADMIN_NAME;
				break;
			case GRPAUTH_MADMIN:
				$status = GRPAUTH_MADMIN_NAME;
				break;
			case GRPAUTH_MEM:
				$status = GRPAUTH_MEM_NAME;
				break;
			case GRPAUTH_NOAPP:
				$status = GRPAUTH_NOAPP_NAME;
				break;
			case GRPAUTH_NOMEM:
				$status = GRPAUTH_NOMEM_NAME;
				break;
			default:
				$status = "";
				break;
		}
		return $status;
	}
	
	// ユーザー数の確認
	public function GetUserCnt($user_id="") {
		$cnt = 0;
		// ユーザの重複を確認する
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	count(user_id) cnt ";
		$sSQL = $sSQL."From user_mst ";
		if ($user_id!="") {
			$sSQL = $sSQL."Where ";
			$sSQL = $sSQL."	 upper(user_id)=".gfQt(strtoupper($user_id));
		}
	
		$rs = parent::get_rs($sSQL);
		if($rs) {
			while( $row = parent::get_row($rs)){
				$cnt = gfGetDBFields($row,"cnt");
				break;				
			}
			parent::free_rs($rs);
		}
		return $cnt;		
	}
	
	// ユーザーIDの形式確認
	public function ChkIDfmt($id) {
		// はてな認証APIを利用する場合
		if (JUGEM_AUTHFLG || HATENA_AUTHFLG || LIVEDOOR_AUTHFLG) {

			if (substr(strtoupper($id),0,strlen(HATENA_SERVICEID)) == strtoupper(HATENA_SERVICEID)) {
				return false;
			}
			if (substr(strtoupper($id),0,strlen(JUGEM_SERVICEID)) == strtoupper(JUGEM_SERVICEID)) {
				return false;
			}
			if (substr(strtoupper($id),0,strlen(LIVEDOOR_SERVICEID)) == strtoupper(LIVEDOOR_SERVICEID)) {
				return false;
			}
		}
		return true;
	}	
	
	// データベースにユーザを登録する
	public function InsUser($id,$name,$pass,$mail,$note,$authapi=false) {
	
		// 認証APIを利用する場合
		if ($authapi == false) {
			if (!self::ChkIDfmt($id)) {
				parent::set_errmsg(USER_ART_013);
				return false;
			}

			// ユーザの重複を確認する
			if (self::GetUserCnt($id)>0) {
				parent::set_errmsg(USER_ART_014);
				return false;
			}
		} else {
			if (self::ChkIDfmt($id)) {
				// 想定外ルート
				gfHackTryLog(__FILE__.__LINE__."InsUser");
				return false;
			}

			// ユーザ登録を確認する
			if (self::GetUserCnt($id)==1) {
				// 既に登録済みであれば登録せずにログイン処理
				return true;
			}

		}

		// サービス利用可能ユーザーの確認
		if (MAX_USER != 0 && $this->GetUserCnt() > MAX_USER) {
			parent::set_errmsg(USER_ART_019);
			return false;
		}
	
		// ユーザを登録する
		$sSQL = "";
		$sSQL = $sSQL."insert into user_mst (";
		$sSQL = $sSQL."	user_id,";
		$sSQL = $sSQL."	user_name,";
		$sSQL = $sSQL."	user_pass,";
		$sSQL = $sSQL."	user_mail,";
		$sSQL = $sSQL."	user_note,";
		$sSQL = $sSQL."	user_state,";
		$sSQL = $sSQL."	upddate,";
		$sSQL = $sSQL."	insdate";
		$sSQL = $sSQL.") values (";
		$sSQL = $sSQL.gfQt($id).",";
		$sSQL = $sSQL.gfQt($name).",";
		$sSQL = $sSQL.gfQt($pass).",";
		$sSQL = $sSQL.gfQt($mail).",";
		$sSQL = $sSQL.gfQt($note).",";
		// メール認証が不要のとき、外部認証のときは仮登録フェイズがないのでフラグをたてる。
		if (!MAIL_NEED || $authapi) {
			$sSQL = $sSQL.USERAUTH_FIX.",";
		} else {
			$sSQL = $sSQL.USERAUTH_NONFIX.",";
		}
		$sSQL = $sSQL."now(),";
		$sSQL = $sSQL."now()";
		$sSQL = $sSQL.") ";
	
		$res = parent::exec_sql($sSQL);
		return $res;

	}
	
	// ユーザー情報更新処理
	public function UpdUserMst($id,$name,$userpass,$usermail,$usernote) {
	
		// 表示状態を更新する。
		$sSQL = "";
		$sSQL = $sSQL."Update user_mst set ";
		$sSQL = $sSQL."	 user_name= ".gfQt($name);
		$sSQL = $sSQL."	 ,user_pass= ".gfQt($userpass);
		$sSQL = $sSQL."	 ,user_mail= ".gfQt($usermail);
		$sSQL = $sSQL."	 ,user_note= ".gfQt($usernote);
		$sSQL = $sSQL."	 ,upddate= now() ";
		$sSQL = $sSQL."where ";
		$sSQL = $sSQL."	 user_id= ".gfQt($id);

		$res = parent::exec_sql($sSQL);
		return $res;
	
	}
	
	// メンバーを脱退
	public function DelMemOut($id,$grpid) {
		$res = false;
		// 自分が最終管理人であるグループを脱退するか確認する
		if (parent::ChkMember($grpid,$id) == GRPAUTH_ADMIN){
			// 所属グループごと削除
			$res = self::DelGrp($grpid);
		} else {
			// メンバーマスタから脱退する
			$sSQL = "";
			$sSQL = $sSQL."Delete from member_tbl where ";
			$sSQL = $sSQL."	 group_no= ".gfQt($grpid);
			$sSQL = $sSQL."	 and user_id= ".gfQt($id);
	
			$res = parent::exec_sql($sSQL);
			if (parent::affected_rows() > 0 ) {
				// ログの書き込み
				parent::InsLog($grpid, "" , "" ,"id::".$id.USER_ART_001 ,TASK_STATUS_DROP,"");
			}
		}
		return $res;
	}
	
	// グループに関連付くものを削除する。
	private function DelGrp($grpid) {
	
		$sSQL = "";
		$sSQL = $sSQL."Delete from group_mst where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($grpid);
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		$sSQL = "";
		$sSQL = $sSQL."Delete from member_tbl where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($grpid);
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		$sSQL = "";
		$sSQL = $sSQL."Delete from taskbox_mst where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($grpid);
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		$sSQL = "";
		$sSQL = $sSQL."Delete from task_tbl where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($grpid);
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		$sSQL = "";
		$sSQL = $sSQL."Delete from view_mst where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($grpid);
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}

		$sSQL = "";
		$sSQL = $sSQL."Delete from data_tbl where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($grpid);
	
		$res = parent::exec_sql($sSQL);
		if (!$res){
			return $res;
		}
	
		$sSQL = "";
		$sSQL = $sSQL."Delete from log_tbl where ";
		$sSQL = $sSQL."	 group_no= ".gfQt($grpid);
	
		$res = parent::exec_sql($sSQL);
		return $res;
	
	}
	
	// ユーザー情報を削除する
	public function DelUser($id) {
	
		$sSQL = "";
		$sSQL = $sSQL."Delete from user_mst where ";
		$sSQL = $sSQL."	 user_id= ".gfQt($id);
	
		$res = parent::exec_sql($sSQL);
	
	}


	//ユーザ情報を確認更新する
	public function UpdUserState($id) {
	
		// ユーザ状態を更新する。
		$sSQL = "";
		$sSQL = $sSQL."Update user_mst set ";
		$sSQL = $sSQL."	 user_state= ".USERAUTH_FIX.", ";
		$sSQL = $sSQL."	 upddate= now() ";
		$sSQL = $sSQL."where ";
		$sSQL = $sSQL."	 user_id= ".gfQt($id);
	
		$res = parent::exec_sql($sSQL);
		if (parent::affected_rows() > 0 ) {
			return true;
		} else {
			return false;
		}
	}
	
}
?>