-- CREATE DATABASE todotask2 DEFAULT CHARACTER SET utf8; 


-- --------------------------------------------------------

-- 
-- テーブルの構造 `group_mst`
-- 

-- 作成日時: 2005 年 12 月 03 日 01:00
-- 最終更新: 2005 年 12 月 03 日 01:00
-- グループno
-- グループ名
-- 優先順位
-- グループ概要
-- グループコメント１(未使用：第三者がコメントをつける時などに使用予定)
-- グループコメント２(未使用：第三者がコメントをつける時などに使用予定)
-- グループコメント３(未使用：第三者がコメントをつける時などに使用予定)
-- 添付フラグ [0:無し/1:有](未使用)
-- 登録者ユーザー
-- 更新日時
-- 作成日時
-- 

DROP TABLE IF EXISTS group_mst;
CREATE TABLE IF NOT EXISTS group_mst (
	group_no int(11) NOT NULL  auto_increment,
	group_name varchar(64) NOT NULL default '',
	group_prio int(11) NOT NULL default 1,
	group_note varchar(255) NOT NULL default '',
	group_com1 varchar(255) default NULL,
	group_com2 varchar(255) default NULL,
	group_com3 varchar(255) default NULL,
	bin_flg char(2) NOT NULL default 0,
	owneruser varchar(32) NOT NULL default '',
	upddate TIMESTAMP NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	insdate TIMESTAMP NOT NULL default '0000-00-00',
	PRIMARY KEY  (group_no),
	KEY group_view (group_prio)
)TYPE=InnoDB AUTO_INCREMENT=1;


-- --------------------------------------------------------

-- 
-- テーブルの構造 `user_mst`
-- 
-- 作成日時: 2005 年 12 月 03 日 01:00
-- 最終更新: 2005 年 12 月 03 日 01:00
-- 
-- ユーザID
-- パスワード
-- ニックネーム
-- メールアドレス
-- ユーザーコメント(所属部署等)
-- ユーザーステータス[0:仮登録/1:本登録]
-- ユーザークッキー
-- ユーザー権限
-- 最後にログインしたHOST(未使用)
-- 更新日時
-- 作成日時
-- 


DROP TABLE IF EXISTS user_mst;
CREATE TABLE IF NOT EXISTS user_mst (
	user_id varchar(32) NOT NULL default '',
	user_pass varchar(64) NOT NULL default '',
	user_name varchar(64) default '',
	user_mail varchar(255) default '',
	user_note varchar(128) default '',
	user_state int(11) NOT NULL default 0,
	user_permit int(11) NOT NULL default 0,
	user_cookie char(64) default NULL,
	last_host varchar(128) default NULL,
	last_login TIMESTAMP default '0000-00-00',
	upddate TIMESTAMP NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	insdate TIMESTAMP NOT NULL default '0000-00-00',
	PRIMARY KEY  (user_id),
	KEY user_mst (user_mail)
)TYPE=InnoDB;


-- --------------------------------------------------------

-- 
-- テーブルの構造 `taskbox_mst`
-- 
-- 作成日時: 2005 年 12 月 03 日 01:00
-- 最終更新: 2005 年 12 月 03 日 01:00
-- 
-- グループno
-- タスクボックスID
-- タスクボックス名
-- タスクボックス優先順位
-- 担当者へメール送信フラグ [1:送る/0:送らない]
-- 更新日時
-- 作成日時
-- 

DROP TABLE IF EXISTS taskbox_mst;
CREATE TABLE IF NOT EXISTS taskbox_mst (
	taskbox_id  int(11) NOT NULL auto_increment,
	group_no int(11) NOT NULL default 0,
	taskbox_name varchar(255) NOT NULL default '',
	taskbox_prio int(11) NOT NULL default 0,
	mailsend_flg char(2) NOT NULL default '1',
	upddate TIMESTAMP NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	insdate TIMESTAMP NOT NULL default '0000-00-00',
	PRIMARY KEY  (taskbox_id,group_no)
) TYPE=InnoDB AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

-- 
-- テーブルの構造 `view_mst`
-- 
-- 作成日時: 2005 年 12 月 03 日 01:00
-- 最終更新: 2005 年 12 月 03 日 01:00
-- 
-- グループno
-- 承認モード [0:必要/1:不必要]
-- 表示モード [0:公開/1:非公開/2:グループにのみ公開]
-- 秘密モード [0:秘密/1:通常]
-- 優先度表示 [0:表示/1:非表示]
-- 進捗度表示 [0:表示/1:非表示]
-- 担当者表示 [0:表示/1:非表示]
-- 期限表示 [0:表示/1:非表示]
-- 登録者表示 [0:表示/1:非表示]
-- 登録日表示 [0:表示/1:非表示]
-- 終了タスク表示 [0:表示/1:非表示]
-- 延期タスク表示 [0:表示/1:非表示]
-- 詳細摘要表示 [0:表示/1:非表示]
-- グループメール機能 [0:使用/1:不使用]
-- ファイル添付機能 [0:使用/1:不使用]
-- コメント機能 [0:使用/1:不使用]
-- コメント数表示 [0:表示/1:非表示]
-- タスクボリューム表示 [0:表示/1:非表示]
-- 承認表示 [0:表示/1:非表示]
-- 警告表示 [0:表示/1:非表示]
-- 警告メールを送る [0:メールを送る/1:メールを送らない]
-- 警告1日時(未処理、処理中のまま更新がないときに警告)
-- 警告2日時(未処理、処理中のまま更新がないときに警告)
-- 削除権限 [0:グループメンバーなら削除可能/1:本人か管理者のみ削除可能]
-- 管理者メッセージ
-- ひとつのタスクボックスに表示する表示件数
-- 特定のタスクボックスのみを表示したときの表示件数
-- 更新日時
-- 作成日時
-- 

DROP TABLE IF EXISTS view_mst;
CREATE TABLE IF NOT EXISTS view_mst (
	group_no int(11) NOT NULL default 0,
	assent_flg char(2) NOT NULL default '0',
	view_flg char(2) NOT NULL default '1',
	secret_flg char(2) NOT NULL default '0',
	priority_flg char(2) NOT NULL default '0',
	gains_flg char(2) NOT NULL default '1',
	do_user_flg char(2) NOT NULL default '0',
	limit_flg char(2) NOT NULL default '0',
	add_user_flg char(2) default '1',
	add_date_flg char(2) NOT NULL default '0',
	fintask_flg char(2) NOT NULL default '1',
	staytask_flg char(2) NOT NULL default '1',
	detail_flg char(2) NOT NULL default '1',
	grpmail_flg char(2) NOT NULL default '1',
	grpfile_flg char(2) NOT NULL default '0',
	grpcmnt_flg char(2) NOT NULL default '0',
	grpcmntcnt_flg char(2) NOT NULL default '0',
	taskvolume_flg char(2) NOT NULL default '0',
	approval_flg char(2) NOT NULL default '1',
	alert_flg char(2) NOT NULL default '0',
	alertmail_flg char(2) NOT NULL default '1',
	alert1_days int(11) NOT NULL default 3,
	alert2_days int(11) NOT NULL default 7,
	group_msg text default NULL,
	delauth_flg char(2) NOT NULL default '1',
	taskboxmax int(11) NOT NULL default 12,
	pagemax int(11) NOT NULL default 100,
	upddate TIMESTAMP NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	insdate TIMESTAMP NOT NULL default '0000-00-00',
	PRIMARY KEY  (group_no)
)TYPE=InnoDB;


-- --------------------------------------------------------

-- 
-- テーブルの構造 `member_tbl`
-- 
-- 作成日時: 2005 年 12 月 03 日 01:00
-- 最終更新: 2005 年 12 月 03 日 01:00
-- 
-- グループno
-- ユーザID
-- 状態 (0:部外者/1:未承認/2:承認/8:マネージャー管理者/9:管理者)
-- 更新日時
-- 作成日時
-- 

DROP TABLE IF EXISTS member_tbl;
CREATE TABLE IF NOT EXISTS member_tbl (
	group_no int(11) NOT NULL default 0,
	user_id varchar(32) NOT NULL default '',
	status char(2) NOT NULL default '0',
	upddate TIMESTAMP NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	insdate TIMESTAMP NOT NULL default '0000-00-00',
	PRIMARY KEY  (group_no,user_id)
)TYPE=InnoDB;


-- --------------------------------------------------------

-- 
-- テーブルの構造 `task_tbl`
-- 
-- 作成日時: 2005 年 12 月 03 日 01:00
-- 最終更新: 2005 年 12 月 03 日 01:00
-- 
-- タスク番号
-- グループno
-- タスクボックスID
-- 優先順位
-- タスク状態 (0:未処理/1:処理中/2:終了/3:延期/4:破棄)
-- タスク期日
-- タスク進捗
-- タスクボリューム
-- タスクボリューム単位（y:年/m:月/d:日/h:時/i:分/s:秒）
-- タスク概要
-- タスク詳細
-- タスク担当者
-- タスク登録者
-- タスク登録日
-- タスク変更者
-- タスク登録時HOST
-- 更新日時
-- 作成日時
-- 

DROP TABLE IF EXISTS task_tbl;
CREATE TABLE IF NOT EXISTS task_tbl (
	task_no int(11) NOT NULL auto_increment,
	group_no int(11) NOT NULL default 0,
	taskbox_id int(11) NOT NULL default 0,
	note varchar(255) NOT NULL default '',
	priority int(11) NOT NULL default 1,
	status char(2) NOT NULL default '0',
	timelimit datetime default Null,
	gains int(11) default 0,
	volume int(11) default 0,
	volunit char(1) NOT NULL default 'd',
	detail text default NULL,
	do_user_id varchar(32) default Null,
	add_user_id varchar(32) NOT NULL default '',
	add_date TIMESTAMP default '0000-00-00',
	edit_user_id varchar(32) default Null,
	remotehost varchar(255) default NULL,
	upddate TIMESTAMP NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	insdate TIMESTAMP NOT NULL default '0000-00-00',
	PRIMARY KEY  (task_no,group_no),
	KEY task_tbl (taskbox_id)
) TYPE=InnoDB AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

-- 
-- テーブルの構造 `cmnt_tbl`
-- 
-- 作成日時: 2007 年 01 月 11 日
-- 最終更新: 2007 年 01 月 11 日
-- 
-- コメント番号
-- タスク番号
-- グループno
-- コメント
-- コメント登録者
-- コメント登録日
-- コメント登録時HOST
-- 更新日時
-- 作成日時
-- 

DROP TABLE IF EXISTS cmnt_tbl;
CREATE TABLE IF NOT EXISTS cmnt_tbl (
	cmnt_no int(11) NOT NULL auto_increment,
	task_no int(11) NOT NULL default 0,
	group_no int(11) NOT NULL default 0,
	cmnt varchar(255) NOT NULL default '',
	add_user_id varchar(32) default Null,
	add_date TIMESTAMP default '0000-00-00',
	remotehost varchar(255) default NULL,
	upddate TIMESTAMP NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	insdate TIMESTAMP NOT NULL default '0000-00-00',
	PRIMARY KEY (cmnt_no,task_no,group_no)
) TYPE=InnoDB AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

-- 
-- テーブルの構造 `data_tbl`
-- 
-- 作成日時: 2007 年 01 月 11 日
-- 最終更新: 2007 年 01 月 11 日
-- 
-- データ番号
-- タスク番号
-- グループno
-- データ
-- データ名
-- データ拡張子
-- データサイズ
-- コメント登録者
-- コメント登録時HOST
-- 更新日時
-- 作成日時
-- 

DROP TABLE IF EXISTS data_tbl;
CREATE TABLE IF NOT EXISTS data_tbl (
	data_no int(11) NOT NULL auto_increment,
	task_no int(11) NOT NULL default 0,
	group_no int(11) NOT NULL default 0,
	data mediumblob NOT NULL,
	data_name varchar(32) NOT NULL default '',
	data_ext varchar(6) NOT NULL default '',
	data_size int(11) NOT NULL default 0,
	add_user_id varchar(32) default Null,
	remotehost varchar(255) default NULL,
	upddate TIMESTAMP NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	insdate TIMESTAMP NOT NULL default '0000-00-00',
	PRIMARY KEY (data_no,task_no,group_no),
	KEY data_view (add_user_id)
) TYPE=InnoDB AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

-- 
-- テーブルの構造 `log_tbl`
-- 
-- 作成日時: 2005 年 12 月 03 日 01:00
-- 最終更新: 2005 年 12 月 03 日 01:00
-- 
-- ログno
-- グループno
-- タスク番号
-- タスクボックスID
-- タスク変更者
-- タスク概要
-- タスク状態 (0:未処理/1:処理中/2:終了/3:延期/4:破棄/10:グループ廃棄)
-- 変更メモ
-- 変更時HOST
-- 更新日時
-- 作成日時
-- 

DROP TABLE IF EXISTS log_tbl;
CREATE TABLE IF NOT EXISTS log_tbl (
	log_no int(11) NOT NULL auto_increment,
	group_no int(11) NOT NULL default 0,
	task_no int(11) NOT NULL default 0,
	taskbox_id int(11) NOT NULL default 0,
	user_id varchar(32) NOT NULL default '',
	note varchar(255) NOT NULL default '',
	status char(50) NOT NULL default '0',
	memo varchar(255) NOT NULL default '',
	remotehost varchar(255) default NULL,
	upddate TIMESTAMP NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	insdate TIMESTAMP NOT NULL default '0000-00-00',
	PRIMARY KEY  (log_no,group_no),
	KEY log_view (task_no,taskbox_id)
) TYPE=InnoDB AUTO_INCREMENT=1 ;


-- --------------------------------------------------------

-- 
-- テーブルの構造 `approval_tbl`
-- 
-- 作成日時: 2007 年 01 月 11 日
-- 最終更新: 2007 年 01 月 11 日
-- 

-- グループno
-- タスク番号
-- タスクボックスID
-- 承認者ID
-- 承認CD
-- 承認日時
-- 更新日時
-- 作成日時
-- 

DROP TABLE IF EXISTS approval_tbl;
CREATE TABLE IF NOT EXISTS approval_tbl (
	group_no int(11) NOT NULL default 0,
	task_no int(11) NOT NULL default 0,
	user_id varchar(32) NOT NULL default '',
	approval_no int(11) NOT NULL default 0,
	add_date TIMESTAMP default '0000-00-00',
	upddate TIMESTAMP NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
	insdate TIMESTAMP NOT NULL default '0000-00-00',
	PRIMARY KEY  (group_no,task_no,user_id),
	KEY log_view (approval_no)
) TYPE=InnoDB;



