<?php
require_once(TODOTASK_DIR.'/app/controllers/db.class.php');

class Login extends Db {
	private $login_flg = false;
	private $loginname = "";
	private $loginid = "";
	private $group_id = "";
	private $group_name = "";
	private $group_prio = "";
	private $group_note = "";

	function __construct( ){
		if (!$this->login_flg) {
			$this->ChkLogin();
		}
	}

	function __destruct(){
	}
	
	// ログイン確認
	public function ChkLogin(){
		if ($this->login_flg){
			return true;
		}

		// 既にログインが完了している
		if (isset($_SESSION[SESSION_LOGIN]) && isset($_SESSION[SESSION_NAMES])) {
			$this->GetSession();
		//クッキーによりログインが保証されている場合
		} else {
			$this->UnsetSession();
			//IDによりPASSを取得してログインチェック
			if (isset($_COOKIE[COOKIE_NAME]) && isset($_COOKIE[COOKIE_ENC])) {
				if (!$this->ChkLoginDB($_COOKIE[COOKIE_NAME],"",$_COOKIE[COOKIE_ENC])) {
					$this->UnsetCookies();
					return false;
				}
			} else {
				return false;
			}
		}
		$this->login_flg = true;
		return true;
	}
	
	public function get_loginname(){
		$sRet = "";
		if ($this->login_flg) {
			$sRet = $this->loginname;			
		} else {
			$sRet = CONST_GESTNAME;			
		}
		return $sRet;
	}

	public function get_loginid(){
		$sRet = "";
		if ($this->login_flg) {
			$sRet = $this->loginid;			
		} else {
			$sRet = "";			
		}
		return $sRet;
	}

	public function ChkLoginDB($id,$pass="",$cookie_enc="") {
		$this->login_flg = false;

		$Ret = false;
	
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	if(".gfQt($pass)." = user_pass,1,0) pass_ret, ";
		$sSQL = $sSQL."	user_id , ";
		$sSQL = $sSQL."	user_name , ";
		$sSQL = $sSQL."	user_pass , ";
		$sSQL = $sSQL."	user_state, ";
		$sSQL = $sSQL."	user_note, ";
		$sSQL = $sSQL."	user_cookie ";
		$sSQL = $sSQL."From user_mst ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 user_id=".gfQt($id);
		$rs = parent::get_rs($sSQL);
		if($rs) {
			while( $row = parent::get_row($rs)){
				if(parent::get_col($row,"user_state") != USERAUTH_FIX) {
					parent::set_errmsg(LOGIN_ART_002);
					break;
				} else if(($pass != "")&&
						  (parent::get_col($row,"pass_ret") != "1")) {
					parent::set_errmsg(LOGIN_ART_003);
					break;
				} else if($cookie_enc != "") {
					if (gfCrypt($this->GetIDseeds($id)) != $cookie_enc
						|| parent::get_col($row,"user_cookie") != $cookie_enc ) {
						parent::set_errmsg(LOGIN_ART_004);
						break;
					}
				}
				$this->loginid =  parent::get_col($row,"user_id");
				$this->loginname =  parent::get_col($row,"user_name");
				$this->login_flg = true;
			}
			parent::free_rs($rs);
			if ($this->login_flg) {
				$this->SetSession();
				$Ret = true;
			} else {
				parent::set_errmsg(LOGIN_ART_005);
			}
		}
		if ($Ret){
			$Ret = $this->InsLoginLog($id);
			if (!$Ret) {
				parent::set_errmsg(LOGIN_ART_006);
			}
		}
		return $Ret;
	}

	// 取得したグループ&タスクボックスが存在するか確認
	public function ChkGroupMst($group_no,$taskboxid="",$taskboxflg=0){
	
		$Ret = false;
		$iCnt = 0; 
		if ($group_no == "") {
			parent::set_errmsg(LOGIN_ERR_008);
			return false;
		}
	
		// タスクグループのチェック
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	count(group_name) cnt, ";
		$sSQL = $sSQL."	group_name, ";
		$sSQL = $sSQL."	group_note, ";
		$sSQL = $sSQL."	group_prio ";
		$sSQL = $sSQL."From group_mst ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
		$sSQL = $sSQL." group by ";
		$sSQL = $sSQL."	 group_name,group_note,group_prio ";
	
		$rs = parent::get_rs($sSQL);
		if($rs) {
			$i= 0;
			while( $row = parent::get_row($rs)){
				$iCnt = gfGetDBFields($row,"cnt"); 
				$this->group_id = $group_no; 
				$this->group_name = gfGetDBFields($row,"group_name"); 
				$this->group_note = gfGetDBFields($row,"group_note"); 
				$this->group_prio = gfGetDBFields($row,"group_prio"); 
			}
			parent::free_rs($rs);
		}
	
		// タスクボックスチェック必須
		if ($taskboxid == "" && $taskboxflg==1) {
			parent::set_errmsg(LOGIN_ERR_009);
			return false;
		}
	
		// タスクボックスのチェック
		if ($taskboxid != "" && $iCnt == 1) {
			$sSQL = "";
			$sSQL = $sSQL."Select ";
			$sSQL = $sSQL."	count(*) cnt ";
			$sSQL = $sSQL."From taskbox_mst ";
			$sSQL = $sSQL."Where ";
			$sSQL = $sSQL."	 group_no=".gfQt($group_no);
			$sSQL = $sSQL."	 and taskbox_id=".gfQt($taskboxid);
			$rs = parent::get_rs($sSQL);
			if($rs) {
				$i= 0;
				while( $row = parent::get_row($rs)){
					$iCnt = gfGetDBFields($row,"cnt"); 
				}
				parent::free_rs($rs);
			}

		}
		if ($iCnt == 1) {
			return true;
		} else {
			return false;
		}
	}

	public function get_group_name($group_no){
		if ($this->group_id != $group_no) {
			return "";			
		} 
		return $this->group_name;
	}

	public function get_group_prio($group_no){
		if ($this->group_id != $group_no) {
			return 1;			
		} 
		return $this->group_prio;
	}

	public function get_group_note($group_no){
		if ($this->group_id != $group_no) {
			return "";			
		} 
		return $this->group_note;
	}

	// ログインしたユーザがこのタスクのメンバーに登録されているか確認
	public function ChkMember($group_no,$id){
		$Ret = GRPAUTH_NOMEM;
		// ログインしているか？
		if (!$this->ChkLogin()) {
			return false;
		}
	
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	status ";
		$sSQL = $sSQL."From member_tbl ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
		$sSQL = $sSQL."	 and user_id=".gfQt($id);
		$sSQL = $sSQL." Group by ";
		$sSQL = $sSQL."	 status ";

		$rs = parent::get_rs($sSQL);
		if($rs) {
			$i= 0;
			while( $row = parent::get_row($rs)){
				$Ret = gfGetDBFields($row,"status"); 
			}
			parent::free_rs($rs);
		}
		return $Ret;

	}

	// ユーザーのメールアドレスが登録されているか確認する
	public function ChkUserMail($user_mail){
		$Ret = false;
	
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	user_id, ";
		$sSQL = $sSQL."	user_name, ";
		$sSQL = $sSQL."	user_note, ";
//		$sSQL = $sSQL."	(to_days(now()) - to_days(upddate)) datedif ";
		$sSQL = $sSQL."	HOUR(timediff(upddate,now())) datedif ";
		$sSQL = $sSQL."From user_mst ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 user_mail=".gfQt($user_mail);
		$sSQL = $sSQL." order by datedif";

		$rs = parent::get_rs($sSQL);
		if($rs) {
			$i= 0;
			while( $row = parent::get_row($rs)){
				$Ret[$i]['user_id'] = gfGetDBFields($row,"user_id"); 
				$Ret[$i]['user_name'] = gfGetDBFields($row,"user_name"); 
				$Ret[$i]['user_note'] = gfGetDBFields($row,"user_note"); 
				$Ret[$i]['datedif'] = gfGetDBFields($row,"datedif"); 
				$i++;
			}
			parent::free_rs($rs);
		}
		return $Ret;
	}

	// ログイン記録
	private function InsLoginLog($id){
		// ユーザ状態を更新する。
		$sSQL = "";
		$sSQL = $sSQL."Update user_mst set ";
		$sSQL = $sSQL."	 user_cookie= ".gfQt(gfCrypt($this->GetIDseeds($id)));
		$sSQL = $sSQL."	 ,last_login= now() ";
		$sSQL = $sSQL."	 ,last_host= ".gfQt($_SERVER['REMOTE_ADDR']);
		$sSQL = $sSQL." where ";
		$sSQL = $sSQL."	 user_id= ".gfQt($id);

		$res = parent::exec_sql($sSQL);
		if (parent::affected_rows() > 0 ) {
			return true;
		} else {
			return false;
		}
	}

	private function GetIDseeds($id){
		$id_seeds = $id;
		if (CHK_LHOST) {
			$id_seeds .= $_SERVER['REMOTE_ADDR'];
		}
		return $id_seeds; 
	}

	private function GetSession(){
		$this->loginid = $_SESSION[SESSION_LOGIN];
		$this->loginname = $_SESSION[SESSION_NAMES];
	}	

	// ログイン状態発行
	private function SetSession(){
		if (!$this->login_flg){
			return false;
		}
		$_SESSION[SESSION_LOGIN] = $this->loginid;
		$_SESSION[SESSION_NAMES] = $this->loginname;
	}	

	// ログイン状態発行
	private function SetCookies(){
		if (!$this->login_flg){
			return false;
		}
		setcookie (COOKIE_NAME, $this->loginid,time()+60*60*24*COOKIE_DAYS, COOKIE_PATH, COOKIE_DOMAIN, COOKIE_SECURE);
		setcookie (COOKIE_ENC, gfCrypt($this->GetIDseeds($this->loginid)),time()+60*60*24*COOKIE_DAYS, COOKIE_PATH, COOKIE_DOMAIN, COOKIE_SECURE);
	}	
	
	// ログイン状態発行
	public function SetLogin(){
		$this->SetCookies();
		$this->SetSession();
	}	


	// ログイン状態解除
	public function UnsetCookies(){
		setcookie (COOKIE_NAME, "", time() - 3600, COOKIE_PATH, COOKIE_DOMAIN, COOKIE_SECURE);
		setcookie (COOKIE_ENC, "", time() - 3600, COOKIE_PATH, COOKIE_DOMAIN, COOKIE_SECURE);
		unset($_COOKIE[COOKIE_NAME]);
		unset($_COOKIE[COOKIE_ENC]);
	}	

	// ログイン状態解除
	private function UnsetSession(){
		if (isset($_SESSION[SESSION_LOGIN])) {
			unset($_SESSION[SESSION_LOGIN]);
		}
		if (isset($_SESSION[SESSION_NAMES])) {
			unset($_SESSION[SESSION_NAMES]);
		}

	}	

	// ログイン状態解除
	public function UnsetLogin(){
		$this->login_flg = false;
		$this->loginname = "";
		$this->loginid = "";
		$this->group_name = "";
		$this->UnsetSession();
		$this->UnsetCookies();
	}	


	// 表示Modeの取得
	public function GetViewMode($group_no,$gmode=TASK_MODE_PAGE) {
		$aryRes = array();

		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	 assent_flg,";
		$sSQL = $sSQL."	 view_flg,";
		$sSQL = $sSQL."	 secret_flg,";
		$sSQL = $sSQL."	 limit_flg,";
		$sSQL = $sSQL."	 priority_flg,";
		$sSQL = $sSQL."	 gains_flg,";
		$sSQL = $sSQL."	 do_user_flg,";
		$sSQL = $sSQL."	 add_user_flg,";
		$sSQL = $sSQL."	 fintask_flg,";
		$sSQL = $sSQL."	 staytask_flg,";
		$sSQL = $sSQL."	 detail_flg,";
		$sSQL = $sSQL."	 grpmail_flg,";
		$sSQL = $sSQL."	 grpfile_flg,";
		$sSQL = $sSQL."	 grpcmnt_flg,";
		$sSQL = $sSQL."	 grpcmntcnt_flg,";
		$sSQL = $sSQL."	 taskvolume_flg,";
		$sSQL = $sSQL."	 approval_flg,";
		$sSQL = $sSQL."	 alert_flg,";
		$sSQL = $sSQL."	 alertmail_flg,";
		$sSQL = $sSQL."	 alert1_days,";
		$sSQL = $sSQL."	 alert2_days,";
		$sSQL = $sSQL."	 delauth_flg,";
		$sSQL = $sSQL."	 group_msg,";
		$sSQL = $sSQL."	 taskboxmax,";
		$sSQL = $sSQL."	 pagemax ";
		$sSQL = $sSQL."From view_mst ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
	
		$rs = parent::get_rs($sSQL);
	
		if($rs) {
			while( $row = parent::get_row($rs)){
				$aryRes["group_no"] = $group_no; 
				$aryRes["assent_flg"] = gfGetDBFields($row,"assent_flg"); 
				$aryRes["view_flg"] = gfGetDBFields($row,"view_flg"); 
				$aryRes["secret_flg"] = gfGetDBFields($row,"secret_flg"); 
				$aryRes["limit_flg"] = gfGetDBFields($row,"limit_flg"); 
				$aryRes["priority_flg"] = gfGetDBFields($row,"priority_flg"); 
				$aryRes["gains_flg"] = gfGetDBFields($row,"gains_flg"); 
				$aryRes["do_user_flg"] = gfGetDBFields($row,"do_user_flg"); 
				$aryRes["add_user_flg"] = gfGetDBFields($row,"add_user_flg"); 
				$aryRes["fintask_flg"] = gfGetDBFields($row,"fintask_flg"); 
				$aryRes["staytask_flg"] = gfGetDBFields($row,"staytask_flg"); 
				$aryRes["detail_flg"] = gfGetDBFields($row,"detail_flg"); 
				$aryRes["grpmail_flg"] = gfGetDBFields($row,"grpmail_flg"); 
				$aryRes["grpfile_flg"] = gfGetDBFields($row,"grpfile_flg"); 
				$aryRes["grpcmnt_flg"] = gfGetDBFields($row,"grpcmnt_flg"); 
				$aryRes["grpcmntcnt_flg"] = gfGetDBFields($row,"grpcmntcnt_flg"); 
				$aryRes["taskvolume_flg"] = gfGetDBFields($row,"taskvolume_flg"); 
				$aryRes["approval_flg"] = gfGetDBFields($row,"approval_flg"); 
				$aryRes["alert_flg"] = gfGetDBFields($row,"alert_flg"); 
				$aryRes["alertmail_flg"] = gfGetDBFields($row,"alertmail_flg"); 
				$aryRes["alert1_days"] = gfGetDBFields($row,"alert1_days"); 
				$aryRes["alert2_days"] = gfGetDBFields($row,"alert2_days"); 
				$aryRes["delauth_flg"] = gfGetDBFields($row,"delauth_flg"); 
				$aryRes["group_msg"] = gfGetDBFields($row,"group_msg"); 
				$aryRes["taskboxmax"] = gfGetDBFields($row,"taskboxmax"); 
				$aryRes["pagemax"] = gfGetDBFields($row,"pagemax"); 
				// 表示件数の設定
				if ($gmode!=TASK_MODE_PAGE) {
					// ひとつのBOXをListで表示する場合
					$aryRes["listcnt"] = $aryRes['pagemax'];
				} else {
					// ボックスを一覧で表示する場合
					$aryRes["listcnt"] = $aryRes['taskboxmax'];
				}
				if ($aryRes["listcnt"] <= 0) {
					$aryRes["listcnt"] = 1;		// ページ表示数
				}

			}
			parent::free_rs($rs);
		}
	
		return $aryRes;
	}


	// 担当者の取得
	public function GetGrpMemberList($group_no,$needdefault = true) {
		$aryRes = array();
		$i = 0;
		if ($needdefault) {
			$aryRes[$i]["user_id"] = ""; 
			$aryRes[$i]["user_name"] = TASK_LABEL_DEFAULT; 
			$i++;
		}
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	mt.user_id ";
		$sSQL = $sSQL."	,um.user_name ";
		$sSQL = $sSQL."	,um.user_mail ";
		$sSQL = $sSQL."	,um.user_note ";
		$sSQL = $sSQL."	,mt.status ";
		$sSQL = $sSQL."From member_tbl mt, ";
		$sSQL = $sSQL."	user_mst um ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 mt.user_id = um.user_id ";
		$sSQL = $sSQL."	 and group_no=".gfQt($group_no);
	
		$rs = parent::get_rs($sSQL);
	
		if($rs) {
			while( $row = parent::get_row($rs)){
				$aryRes[$i]["user_id"] = gfGetDBFields($row,"user_id"); 
				$aryRes[$i]["user_name"] = gfGetDBFields($row,"user_name"); 
				$aryRes[$i]["user_mail"] = gfGetDBFields($row,"user_mail"); 
				$aryRes[$i]["user_note"] = gfGetDBFields($row,"user_note"); 
				$aryRes[$i]["status"] = gfGetDBFields($row,"status"); 
				$i++;
			}
			parent::free_rs($rs);
		}
		return $aryRes;
	}

	// タスクボックスの取得
	public function GetTaskbox($group_no,$taskboxid="",$gmode=TASK_MODE_PAGE) {
		$aryRes = array();
	
		// タスクボックス名の表示
		$sSQL = "";
		$sSQL = $sSQL."Select ";
		$sSQL = $sSQL."	taskbox_id, ";
		$sSQL = $sSQL."	taskbox_name, ";
		$sSQL = $sSQL."	taskbox_prio, ";
		$sSQL = $sSQL."	mailsend_flg ";
		$sSQL = $sSQL."From taskbox_mst ";
		$sSQL = $sSQL."Where ";
		$sSQL = $sSQL."	 group_no=".gfQt($group_no);
		if ($gmode==TASK_MODE_BOX) {
			$sSQL = $sSQL."	 and if(".gfQt($taskboxid)."='',1,taskbox_id=".gfQt($taskboxid).") ";
		}
		$sSQL = $sSQL."Order By ";
		$sSQL = $sSQL."	taskbox_prio desc,taskbox_id,taskbox_name ";

		$rs = parent::get_rs($sSQL);
	
		if($rs) {
			$i = 0;
			while( $row = parent::get_row($rs)){
				$aryRes[$i]["group_no"] = $group_no; 
				$aryRes[$i]["taskbox_id"] = gfGetDBFields($row,"taskbox_id"); 
				$aryRes[$i]["taskbox_name"] = gfGetDBFields($row,"taskbox_name"); 
				$aryRes[$i]["taskbox_prio"] = gfGetDBFields($row,"taskbox_prio"); 
				$aryRes[$i]["mailsend_flg"] = gfGetDBFields($row,"mailsend_flg"); 
				$i++;
			}
			parent::free_rs($rs);
		}
	
		return $aryRes;
	}
	
}

?>