/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.imagegenerator.generator.converter;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.tmdmaker.imagegenerator.generator.converter.ImageFormatConverter;

public class GifImageFormatConverter
implements ImageFormatConverter {
    @Override
    public void convert(String file, int imageType, Image image) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{this.convertImageData(image)};
        loader.save(file, imageType);
    }

    private ImageData convertImageData(Image image) {
        ImageData data = image.getImageData();
        if (!data.palette.isDirect && data.depth <= 8) {
            return data;
        }
        HashMap<RGB, ColorCounter> freq = new HashMap<RGB, ColorCounter>();
        int width = data.width;
        int[] pixels = new int[width];
        int[] maskPixels = new int[width];
        int y = 0;
        int height = data.height;
        while (y < height) {
            data.getPixels(0, y, width, pixels, 0);
            int x = 0;
            while (x < width) {
                RGB rgb = data.palette.getRGB(pixels[x]);
                ColorCounter counter = (ColorCounter)freq.get(rgb);
                if (counter == null) {
                    counter = new ColorCounter();
                    counter.rgb = rgb;
                    freq.put(rgb, counter);
                }
                ++counter.count;
                ++x;
            }
            ++y;
        }
        Object[] counters = new ColorCounter[freq.size()];
        freq.values().toArray(counters);
        Arrays.sort(counters);
        ImageData mask = null;
        if (data.transparentPixel != -1 || data.maskData != null) {
            mask = data.getTransparencyMask();
        }
        int n = Math.min(256, freq.size());
        RGB[] rgbs = new RGB[n + (mask != null ? 1 : 0)];
        int i = 0;
        while (i < n) {
            rgbs[i] = ((ColorCounter)counters[i]).rgb;
            ++i;
        }
        if (mask != null) {
            rgbs[rgbs.length - 1] = data.transparentPixel != -1 ? data.palette.getRGB(data.transparentPixel) : new RGB(255, 255, 255);
        }
        PaletteData palette = new PaletteData(rgbs);
        ImageData newData = new ImageData(width, data.height, 8, palette);
        if (mask != null) {
            newData.transparentPixel = rgbs.length - 1;
        }
        int y2 = 0;
        int height2 = data.height;
        while (y2 < height2) {
            data.getPixels(0, y2, width, pixels, 0);
            if (mask != null) {
                mask.getPixels(0, y2, width, maskPixels, 0);
            }
            int x = 0;
            while (x < width) {
                if (mask != null && maskPixels[x] == 0) {
                    pixels[x] = rgbs.length - 1;
                } else {
                    RGB rgb = data.palette.getRGB(pixels[x]);
                    pixels[x] = this.closest(rgbs, n, rgb);
                }
                ++x;
            }
            newData.setPixels(0, y2, width, pixels, 0);
            ++y2;
        }
        return newData;
    }

    private int closest(RGB[] rgbs, int n, RGB rgb) {
        int minDist = 196608;
        int minIndex = 0;
        int i = 0;
        while (i < n) {
            RGB rgb2 = rgbs[i];
            int da = rgb2.red - rgb.red;
            int dg = rgb2.green - rgb.green;
            int db = rgb2.blue - rgb.blue;
            int dist = da * da + dg * dg + db * db;
            if (dist < minDist) {
                minDist = dist;
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    static class ColorCounter
    implements Comparable<ColorCounter> {
        RGB rgb;
        int count;

        ColorCounter() {
        }

        @Override
        public int compareTo(ColorCounter o) {
            return o.count - this.count;
        }
    }
}

