/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.preferences.appearance;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.tmdmaker.ui.preferences.appearance.ModelAppearance;

public class AppearanceSetting {
    private static AppearanceSetting setting;
    public static final boolean ENABLE_COLOR = false;
    private boolean colorEnabled = false;
    private Map<ModelAppearance, Colors> colorMap = new HashMap<ModelAppearance, Colors>();

    public static AppearanceSetting getInstance() {
        if (setting == null) {
            setting = new AppearanceSetting();
        }
        return setting;
    }

    public boolean isColorEnabled() {
        return this.colorEnabled;
    }

    public void setColorEnabled(boolean colorEnabled) {
        this.colorEnabled = colorEnabled;
    }

    public void setColors(ModelAppearance appearance, RGB background, RGB font) {
        Colors value = this.colorMap.get((Object)appearance);
        if (value == null) {
            value = new Colors();
        }
        value.background = background;
        value.font = font;
        this.colorMap.put(appearance, value);
    }

    public void setBackground(ModelAppearance appearance, RGB background) {
        Colors value = this.colorMap.get((Object)appearance);
        if (value == null) {
            value = new Colors();
        }
        value.background = background;
        this.colorMap.put(appearance, value);
    }

    public void setFont(ModelAppearance appearance, RGB font) {
        Colors value = this.colorMap.get((Object)appearance);
        if (value == null) {
            value = new Colors();
        }
        value.font = font;
        this.colorMap.put(appearance, value);
    }

    public RGB getBackground(ModelAppearance appearance) {
        Colors value = this.colorMap.get((Object)appearance);
        if (value != null) {
            return value.background;
        }
        return null;
    }

    public RGB getFont(ModelAppearance appearance) {
        Colors value = this.colorMap.get((Object)appearance);
        if (value != null) {
            return value.font;
        }
        return null;
    }

    private static class Colors {
        public RGB background;
        public RGB font;

        private Colors() {
        }
    }
}

