/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.dialogs.model;

import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.DataTypeDeclaration;
import org.tmdmaker.core.model.Entity;
import org.tmdmaker.core.model.EntityType;
import org.tmdmaker.core.model.Identifier;
import org.tmdmaker.core.model.Laputa;
import org.tmdmaker.core.model.StandardSQLDataType;
import org.tmdmaker.core.model.parts.ModelName;
import org.tmdmaker.ui.dialogs.model.EditAttribute;

public class EntityCreationModel {
    private EditAttribute identifier = new EditAttribute();
    private ModelName entityName = new ModelName();
    private EntityType entityType = EntityType.RESOURCE;
    private boolean entityNameAutoGeneration = true;

    public boolean isEntityNameAutoGeneration() {
        return this.entityNameAutoGeneration;
    }

    public void setEntityNameAutoGeneration(boolean entityNameAutoGeneration) {
        this.entityNameAutoGeneration = entityNameAutoGeneration;
        if (this.isEntityNameAutoGeneration()) {
            this.generateEntityNameFromIdentifier();
        }
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void setIdentifierName(String identifierName) {
        this.identifier.setName(identifierName);
        if (this.isEntityNameAutoGeneration()) {
            this.generateEntityNameFromIdentifier();
        }
    }

    private void generateEntityNameFromIdentifier() {
        this.entityName = new Identifier(this.identifier.getName()).createEntityName();
    }

    public EditAttribute getIdentifier() {
        return this.identifier;
    }

    public ModelName getEntityName() {
        return this.entityName;
    }

    public void setEntityName(ModelName entityName) {
        this.entityName = entityName;
    }

    private boolean isLaputa() {
        return this.entityType.equals((Object)EntityType.LAPUTA);
    }

    private boolean isEvent() {
        return this.entityType.equals((Object)EntityType.EVENT);
    }

    private boolean isValidEntity() {
        return !this.entityName.isEmpty() && this.identifier.isValid();
    }

    public boolean isValid() {
        return this.isLaputa() || this.isValidEntity();
    }

    public AbstractEntityModel getCreateModel() {
        Identifier newIdentifier = this.identifier.toIdentifier();
        newIdentifier.setDataTypeDeclaration(new DataTypeDeclaration(StandardSQLDataType.CHARACTER_VARYING, Integer.valueOf(10), null));
        if (this.isLaputa()) {
            return Laputa.of((ModelName)this.entityName, (Identifier)newIdentifier);
        }
        Entity entity = null;
        entity = this.isEvent() ? Entity.ofEvent((ModelName)this.entityName, (Identifier)newIdentifier) : Entity.ofResource((ModelName)this.entityName, (Identifier)newIdentifier);
        entity.withDefaultAttribute();
        return entity;
    }
}

