/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.dialogs;

import java.beans.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.tmdmaker.core.model.VirtualEntity;
import org.tmdmaker.core.model.VirtualEntityType;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.dialogs.ModelEditDialog;
import org.tmdmaker.ui.dialogs.components.AttributeSettingPanel;
import org.tmdmaker.ui.dialogs.components.ImplementInfoSettingPanel;
import org.tmdmaker.ui.dialogs.components.TableNameSettingPanel;
import org.tmdmaker.ui.dialogs.model.EditVirtualEntity;

public class VirtualEntityEditDialog
extends ModelEditDialog<VirtualEntity> {
    private TableNameSettingPanel panel1;
    private AttributeSettingPanel panel2;
    private ImplementInfoSettingPanel panel3;
    private Combo typeCombo;

    public VirtualEntityEditDialog(Shell parentShell, VirtualEntity original) {
        super(parentShell);
        this.entity = new EditVirtualEntity(original);
        this.entity.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Button okButton;
        if (evt.getPropertyName().equals("_edit_property_attributes")) {
            this.panel2.updateAttributeTable();
        }
        if ((okButton = this.getButton(0)) != null) {
            okButton.setEnabled(this.entity.isValid());
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.EditVirtualEntity);
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.panel1 = new TableNameSettingPanel(composite, 0, this.entity);
        GridData gridData = new GridData(768);
        this.panel1.setLayoutData(gridData);
        this.typeCombo = new Combo(composite, 8);
        this.typeCombo.add(Messages.Normal);
        this.typeCombo.add(Messages.ResourceType);
        this.typeCombo.add(Messages.EventType);
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VirtualEntityEditDialog.this.getEditModel().setVirtualEntityType(VirtualEntityType.values()[VirtualEntityEditDialog.this.typeCombo.getSelectionIndex()]);
            }
        });
        this.panel3 = new ImplementInfoSettingPanel(composite, 0, this.entity);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.panel3.setLayoutData(gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.panel2 = new AttributeSettingPanel(composite, 0, this.entity);
        this.panel2.setLayoutData(gridData);
        composite.pack();
        this.initializeTypeCombo();
        return composite;
    }

    private void initializeTypeCombo() {
        this.typeCombo.select(this.getEditModel().getVirtualEntityType().ordinal());
    }

    protected void okPressed() {
        this.editedValue = (VirtualEntity)this.entity.createEditedModel();
        super.okPressed();
    }

    @Override
    protected EditVirtualEntity getEditModel() {
        return (EditVirtualEntity)this.entity;
    }
}

