/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.actions.gef3;

import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Header2DetailRelationship;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.actions.gef3.AbstractEntitySelectionAction;

public class MultivalueAndSupersetShowAction
extends AbstractEntitySelectionAction {
    public static final String ID = "_MVA_SE_SHOW";

    public MultivalueAndSupersetShowAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.ShowMultivalueAndSuperset);
        this.setId(ID);
    }

    @Override
    protected boolean calculateEnabled() {
        if (super.calculateEnabled()) {
            AbstractEntityModel entity = this.getModel();
            if (!entity.isHeaderDetail()) {
                return false;
            }
            Header2DetailRelationship r = entity.getHeader2DetailRelationship();
            return r != null && !r.isSupersetConnected();
        }
        return false;
    }

    public void run() {
        MultivalueAndSupersetShowCommand command = new MultivalueAndSupersetShowCommand(this.getModel().getHeader2DetailRelationship());
        this.execute(command);
    }

    private static class MultivalueAndSupersetShowCommand
    extends Command {
        private Header2DetailRelationship relationship;

        public MultivalueAndSupersetShowCommand(Header2DetailRelationship relationship) {
            this.relationship = relationship;
        }

        public void execute() {
            this.relationship.connectSuperset();
        }

        public void undo() {
            this.relationship.disconnectSuperset();
        }
    }
}

