/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import java.util.ArrayList;
import java.util.List;
import org.tmdmaker.core.model.AbstractConnectionModel;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.AbstractSubsetType;
import org.tmdmaker.core.model.ConnectableElement;
import org.tmdmaker.core.model.Entity2SubsetTypeRelationship;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.IVisitor;
import org.tmdmaker.core.model.SubsetEntity;

public class SubsetType
extends AbstractSubsetType<AbstractEntityModel> {
    private SubsetTypeValue subsetType = SubsetTypeValue.SAME;
    public static final String PROPERTY_PARTITION = "_property_partition";
    public static final String PROPERTY_TYPE = "_property_type";
    private IAttribute partitionAttribute;
    private boolean exceptNull;

    protected SubsetType() {
    }

    @Override
    public List<SubsetEntity> getSubsetList() {
        ArrayList<SubsetEntity> results = new ArrayList<SubsetEntity>();
        for (AbstractConnectionModel c : this.getModelSourceConnections()) {
            ConnectableElement m = c.getTarget();
            if (!(m instanceof SubsetEntity)) continue;
            results.add((SubsetEntity)m);
        }
        return results;
    }

    public SubsetTypeValue getSubsetType() {
        return this.subsetType;
    }

    public void setSubsetType(SubsetTypeValue subsetType) {
        SubsetTypeValue oldValue = this.subsetType;
        this.subsetType = subsetType;
        this.firePropertyChange(PROPERTY_TYPE, (Object)oldValue, (Object)this.subsetType);
        this.firePartitionChanged();
    }

    public IAttribute getPartitionAttribute() {
        return this.partitionAttribute;
    }

    public void setPartitionAttribute(IAttribute partitionAttribute) {
        IAttribute oldValue = this.partitionAttribute;
        this.partitionAttribute = partitionAttribute;
        this.firePropertyChange(PROPERTY_PARTITION, oldValue, partitionAttribute);
        this.firePartitionChanged();
    }

    public boolean isExceptNull() {
        return this.exceptNull;
    }

    public void setExceptNull(boolean exceptNull) {
        boolean oldValue = this.exceptNull;
        this.exceptNull = exceptNull;
        this.firePropertyChange(PROPERTY_PARTITION, oldValue, this.partitionAttribute);
        this.firePartitionChanged();
    }

    public void firePartitionChanged() {
        this.notifySuperset();
        this.nofityRelationship();
        this.notifySubsetEntity();
    }

    public Entity2SubsetTypeRelationship getEntityRelationship() {
        if (!this.getModelTargetConnections().isEmpty()) {
            return (Entity2SubsetTypeRelationship)this.getModelTargetConnections().get(0);
        }
        return null;
    }

    @Override
    public AbstractEntityModel getSuperset() {
        Entity2SubsetTypeRelationship r = this.getEntityRelationship();
        if (r != null) {
            return (AbstractEntityModel)r.getSource();
        }
        return null;
    }

    private void notifySuperset() {
        AbstractEntityModel superset = this.getSuperset();
        if (superset != null) {
            superset.firePropertyChange(PROPERTY_PARTITION, null, (Object)this.getSubsetType());
        }
    }

    private void nofityRelationship() {
        Entity2SubsetTypeRelationship r = this.getEntityRelationship();
        if (r != null) {
            r.firePartitionChanged();
        }
    }

    private void notifySubsetEntity() {
        for (SubsetEntity s : this.getSubsetList()) {
            s.firePropertyChange(PROPERTY_PARTITION, null, (Object)this.getSubsetType());
        }
    }

    public boolean isSameType() {
        return this.subsetType.equals((Object)SubsetTypeValue.SAME);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public boolean hasSubsetEntity() {
        return !this.getModelSourceConnections().isEmpty();
    }

    public static enum SubsetTypeValue {
        SAME,
        DIFFERENT;

    }
}

