/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.AbstractRelationship;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.IVisitor;
import org.tmdmaker.core.model.RecursiveTable;
import org.tmdmaker.core.model.rule.ImplementRule;

public class RecursiveRelationship
extends AbstractRelationship {
    private RecursiveTable table;
    private Diagram diagram;

    public RecursiveRelationship(AbstractEntityModel source) {
        this.setSource(source);
        this.diagram = this.getSource().getDiagram();
        this.table = RecursiveRelationship.createRecursiveTable(source);
        this.setTarget(this.table);
    }

    private static RecursiveTable createRecursiveTable(AbstractEntityModel model) {
        RecursiveTable table = new RecursiveTable();
        table.setEntityType(model.getEntityType());
        table.setName(RecursiveRelationship.createRecursiveTableName(model));
        ImplementRule.setModelDefaultValue(table);
        table.addCreationIdentifier(model);
        return table;
    }

    private static String createRecursiveTableName(AbstractEntityModel model) {
        String name = model.getName();
        return String.valueOf(name) + "." + name + "." + "\u518d\u5e30\u8868";
    }

    @Override
    public void connect() {
        AbstractEntityModel sourceEntity;
        if (this.diagram != null) {
            this.diagram.addChild(this.table);
        }
        if (!(sourceEntity = this.getSource()).getModelSourceConnections().contains(this)) {
            sourceEntity.addSourceConnection(this);
        }
        this.table.addTargetConnection(this);
        this.attachSource();
        this.attachTarget();
    }

    @Override
    public void disconnect() {
        this.getSource().removeSourceConnection(this);
        this.table.removeTargetConnection(this);
        if (this.diagram != null) {
            this.diagram.removeChild(this.table);
        }
    }

    @Override
    public boolean isDeletable() {
        return this.table.isDeletable();
    }

    @Override
    public String getTargetName() {
        return this.getSourceName();
    }

    @Override
    public void identifierChanged() {
        this.table.removeReusedIdentifier(this.getSource());
        this.table.addCreationIdentifier(this.getSource());
        this.table.fireIdentifierChanged(this);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean hasTable() {
        return true;
    }

    @Override
    public RecursiveTable getTable() {
        return this.table;
    }
}

