/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.generate.ddl.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.DataTypeDeclaration;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.IdentifierRef;
import org.tmdmaker.core.model.KeyModel;
import org.tmdmaker.core.model.ModelElement;
import org.tmdmaker.core.model.ReusedIdentifier;
import org.tmdmaker.core.model.StandardSQLDataType;
import org.tmdmaker.core.model.SurrogateKeyRef;
import org.tmdmaker.core.model.rule.ImplementRule;
import org.tmdmaker.generate.ddl.internal.ForeignConstraints;

public class DdlUtilsConverter {
    private static Logger logger = LoggerFactory.getLogger(DdlUtilsConverter.class);
    private List<ForeignConstraints> foreignConstraintsList = new ArrayList<ForeignConstraints>();
    private boolean foreignKeyEnabled;

    public DdlUtilsConverter() {
        this(false);
    }

    public DdlUtilsConverter(boolean foreignKeyEnabled) {
        this.foreignKeyEnabled = foreignKeyEnabled;
    }

    public Database convert(Diagram diagram, List<AbstractEntityModel> models) {
        Database database = this.createDatabase(diagram);
        this.addModels(database, models);
        if (this.foreignKeyEnabled) {
            for (ForeignConstraints foreignConstraints : this.foreignConstraintsList) {
                foreignConstraints.addForeignKeys(database);
            }
        }
        return database;
    }

    private Database createDatabase(Diagram diagram) {
        Database database = new Database();
        database.setName(diagram.getName());
        return database;
    }

    private void addModels(Database database, List<AbstractEntityModel> models) {
        for (AbstractEntityModel model : models) {
            this.addModel(database, (ModelElement)model);
        }
    }

    private void addModel(Database database, ModelElement model) {
        if (!(model instanceof AbstractEntityModel)) {
            return;
        }
        AbstractEntityModel entity = (AbstractEntityModel)model;
        if (entity.isNotImplement()) {
            return;
        }
        database.addTable(this.convert(entity));
    }

    private Table convert(AbstractEntityModel entity) {
        Table table = new Table();
        String tableName = entity.getImplementName();
        if (tableName == null || tableName.length() == 0) {
            tableName = entity.getName();
        }
        table.setName(tableName);
        table.setDescription(entity.getName());
        HashMap<IAttribute, Column> attributeColumnMap = new HashMap<IAttribute, Column>();
        this.addColumns(entity, table, attributeColumnMap);
        this.addIndices(entity, table, attributeColumnMap);
        this.foreignConstraintsList.add(this.createForeignConstraints(entity, table));
        return table;
    }

    private void addColumns(AbstractEntityModel entity, Table table, Map<IAttribute, Column> attributeColumnMap) {
        List attributes = ImplementRule.findAllImplementAttributes((AbstractEntityModel)entity);
        for (IAttribute a : attributes) {
            Column column = this.convert(a);
            table.addColumn(column);
            attributeColumnMap.put(a, column);
        }
    }

    private ForeignConstraints createForeignConstraints(AbstractEntityModel entity, Table table) {
        logger.trace("createForeignConstraints {} {}", (Object)entity.getName(), (Object)table.getName());
        ForeignConstraints foreignConstraints = new ForeignConstraints(table);
        for (Map.Entry reusedMap : entity.getReusedIdentifiers().entrySet()) {
            AbstractEntityModel foreignEntity = (AbstractEntityModel)reusedMap.getKey();
            ReusedIdentifier reused = (ReusedIdentifier)reusedMap.getValue();
            foreignConstraints.addForeignReference(foreignEntity.getImplementName(), this.convert(reused), this.isRecursive(reused));
        }
        return foreignConstraints;
    }

    private Boolean isRecursive(ReusedIdentifier reused) {
        int count = reused.getSurrogateKeys().size();
        if (count == 2) {
            return true;
        }
        return false;
    }

    private List<Reference> convert(ReusedIdentifier reused) {
        ArrayList<Reference> refences = new ArrayList<Reference>();
        if (reused.isSurrogateKeyEnabled()) {
            SurrogateKeyRef sref = (SurrogateKeyRef)reused.getSurrogateKeys().get(0);
            Column localColumn = this.convert((IAttribute)sref);
            Column originalColumn = this.convert((IAttribute)sref.getOriginal());
            this.addReference(refences, localColumn, originalColumn);
            return refences;
        }
        List list = reused.getUniqueIdentifiers();
        int reusedCount = list.size();
        if (this.isRecursive(reused).booleanValue()) {
            reusedCount /= 2;
        }
        int i = 0;
        while (i < reusedCount) {
            IdentifierRef iref = (IdentifierRef)list.get(i);
            Column localColumn = this.convert((IAttribute)iref);
            Column originalColumn = this.convert((IAttribute)iref.getOriginal());
            this.addReference(refences, localColumn, originalColumn);
            ++i;
        }
        return refences;
    }

    private void addReference(List<Reference> refences, Column localColumn, Column originalColumn) {
        Reference reference = new Reference(localColumn, originalColumn);
        refences.add(reference);
        logger.debug("\u53c2\u7167\uff1a {}->{}", (Object)localColumn.getName(), (Object)originalColumn.getName());
    }

    private void addIndices(AbstractEntityModel entity, Table table, Map<IAttribute, Column> attributeColumnMap) {
        for (KeyModel idx : entity.getKeyModels()) {
            if (idx.isMasterKey()) {
                this.markPrimaryKeys(table, idx);
                continue;
            }
            table.addIndex(this.convert(idx, attributeColumnMap));
        }
    }

    private void markPrimaryKeys(Table table, KeyModel idx) {
        for (IAttribute a : idx.getAttributes()) {
            Column c = table.findColumn(a.getImplementName());
            if (c == null) continue;
            c.setPrimaryKey(true);
        }
    }

    private Index convert(KeyModel key, Map<IAttribute, Column> attributeColumnMap) {
        Object index = null;
        index = key.isUnique() ? new UniqueIndex() : new NonUniqueIndex();
        index.setName(key.getName());
        for (IAttribute attr : key.getAttributes()) {
            Column column = attributeColumnMap.get(attr);
            if (column != null) {
                IndexColumn indexColumn = new IndexColumn(column);
                index.addColumn(indexColumn);
                continue;
            }
            logger.error("column not found.{}", (Object)attr.getName());
        }
        return index;
    }

    private Column convert(IAttribute attribute) {
        Column column = new Column();
        String columnName = attribute.getImplementName();
        if (columnName == null || columnName.length() == 0) {
            columnName = attribute.getName();
        }
        column.setName(columnName);
        DataTypeDeclaration dtd = attribute.getDataTypeDeclaration();
        if (dtd != null) {
            String defaultValue;
            StandardSQLDataType dataType = dtd.getLogicalType();
            column.setTypeCode(dataType.getSqlType());
            if (dataType.isSupportSize() && dtd.getSize() != null) {
                column.setSize(dtd.getSize().toString());
            }
            if (dataType.isSupportScale() && dtd.getScale() != null) {
                column.setScale(dtd.getScale().intValue());
            }
            if (dtd.getAutoIncrement() != null) {
                column.setAutoIncrement(dtd.getAutoIncrement().booleanValue());
            }
            if (StringUtils.isNotEmpty((String)(defaultValue = dtd.getDefaultValue()))) {
                column.setDefaultValue(defaultValue);
            }
        }
        column.setRequired(!attribute.isNullable());
        return column;
    }

    public void addCommonColumns(Database database, List<IAttribute> commonAttributes) {
        if (commonAttributes == null) {
            return;
        }
        Table[] tableArray = database.getTables();
        int n = tableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Table t = tableArray[n2];
            this.addCommonColumns(t, commonAttributes);
            ++n2;
        }
    }

    private void addCommonColumns(Table t, List<IAttribute> commonAttributes) {
        for (IAttribute a : commonAttributes) {
            t.addColumn(this.convert(a));
        }
    }
}

