/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.editpolicies;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Attribute;
import org.tmdmaker.ui.editor.gef3.commands.AttributeMoveCommand;
import org.tmdmaker.ui.editor.gef3.commands.AttributeTransferCommand;
import org.tmdmaker.ui.editor.gef3.editparts.node.AbstractModelEditPart;
import org.tmdmaker.ui.editor.gef3.editparts.node.AttributeEditPart;
import org.tmdmaker.ui.editor.gef3.editpolicies.ToolbarLayoutEditPolicy;

public class EntityLayoutEditPolicy
extends ToolbarLayoutEditPolicy {
    private static Logger logger = LoggerFactory.getLogger(EntityLayoutEditPolicy.class);

    protected Command createAddCommand(EditPart child, EditPart after) {
        logger.debug("{}#createAddCommand()", ((Object)((Object)this)).getClass());
        if (!(child instanceof AttributeEditPart)) {
            logger.debug("child is not AttributeEditPart.{}", (Object)child);
            return null;
        }
        Attribute toMove = (Attribute)child.getModel();
        AbstractModelEditPart originalEntityEditPart = (AbstractModelEditPart)child.getParent();
        AbstractEntityModel originalEntity = (AbstractEntityModel)originalEntityEditPart.getModel();
        int oldIndex = originalEntityEditPart.getChildren().indexOf(child);
        AbstractModelEditPart newEntityEditPart = null;
        int newIndex = 0;
        if (after == null) {
            newEntityEditPart = (AbstractModelEditPart)this.getHost();
            newIndex = newEntityEditPart.getChildren().size();
        } else if (after instanceof AttributeEditPart) {
            newEntityEditPart = (AbstractModelEditPart)this.getHost();
            newIndex = newEntityEditPart.getChildren().indexOf(after);
        } else {
            logger.debug("after is null or not AttributeEditPart.{}", (Object)after);
            return null;
        }
        AbstractEntityModel newEntity = (AbstractEntityModel)newEntityEditPart.getModel();
        return new AttributeTransferCommand(toMove, originalEntity, oldIndex, newEntity, newIndex);
    }

    protected Command createMoveChildCommand(EditPart child, EditPart after) {
        logger.debug("{}#createMoveChildCommand()", ((Object)((Object)this)).getClass());
        AbstractModelEditPart parent = (AbstractModelEditPart)this.getHost();
        AbstractEntityModel model = (AbstractEntityModel)parent.getModel();
        Attribute attribute = (Attribute)child.getModel();
        int oldIndex = parent.getChildren().indexOf(child);
        int newIndex = 0;
        newIndex = after != null ? parent.getChildren().indexOf(after) : parent.getChildren().size();
        return new AttributeMoveCommand(attribute, model, oldIndex, newIndex);
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }
}

