/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.commands;

import org.eclipse.gef.commands.Command;
import org.tmdmaker.core.model.AbstractConnectionModel;
import org.tmdmaker.core.model.ConnectableElement;
import org.tmdmaker.ui.editor.draw2d.ConstraintAdjuster;
import org.tmdmaker.ui.editor.draw2d.ConstraintAdjusterFactory;

public class ConnectionCreateCommand
extends Command {
    private ConnectableElement source;
    private ConnectableElement target;
    private AbstractConnectionModel connection;

    public ConnectionCreateCommand() {
    }

    public ConnectionCreateCommand(AbstractConnectionModel connection, ConnectableElement source, ConnectableElement target) {
        this.setConnection(connection);
        this.setSource(source);
        this.setTarget(target);
    }

    public boolean canExecute() {
        return this.source != null && this.target != null && this.connection != null;
    }

    public void execute() {
        this.connection.connect();
        ConstraintAdjuster adjuster = ConstraintAdjusterFactory.getAdjuster(this.connection);
        adjuster.adjust();
    }

    public void undo() {
        this.connection.disconnect();
    }

    public void setConnection(AbstractConnectionModel connection) {
        this.connection = connection;
    }

    public void setSource(ConnectableElement source) {
        this.source = source;
    }

    public void setTarget(ConnectableElement target) {
        this.target = target;
    }

    public AbstractConnectionModel getConnection() {
        return this.connection;
    }

    public ConnectableElement getSource() {
        return this.source;
    }

    public ConnectableElement getTarget() {
        return this.target;
    }
}

