/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.imagegenerator.generator;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.tmdmaker.imagegenerator.generator.ImageGenerator;
import org.tmdmaker.imagegenerator.generator.converter.DefaultImageFormatConverer;
import org.tmdmaker.imagegenerator.generator.converter.ImageFormatConverter;

public class RasterImageGenerator
implements ImageGenerator {
    private final ImageFormatConverter imageDataConverter;

    public RasterImageGenerator() {
        this.imageDataConverter = new DefaultImageFormatConverer();
    }

    public RasterImageGenerator(ImageFormatConverter imageDataConverter) {
        this.imageDataConverter = imageDataConverter;
    }

    @Override
    public void execute(IFigure rootFigure, String file, int imageType) {
        Rectangle rectangle = rootFigure.getBounds();
        Image image = new Image((Device)Display.getDefault(), rectangle.width + 50, rectangle.height + 50);
        GC gc = new GC((Drawable)image);
        SWTGraphics graphics = new SWTGraphics(gc);
        graphics.translate(rectangle.getLocation().negate());
        rootFigure.paint((Graphics)graphics);
        this.imageDataConverter.convert(file, imageType, image);
        gc.dispose();
        image.dispose();
    }
}

