/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model.generate.attributelist;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Detail;
import org.tmdmaker.core.model.Entity;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.Identifier;
import org.tmdmaker.core.model.generate.attributelist.EntityAttributePair;

public class AttributeListModelBuilder {
    public Map<String, EntityAttributePair> build(List<AbstractEntityModel> models) {
        TreeMap<String, EntityAttributePair> attributes = new TreeMap<String, EntityAttributePair>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        for (AbstractEntityModel m : models) {
            Detail d;
            EntityAttributePair pair;
            Identifier i;
            if (m instanceof Entity) {
                Entity e = (Entity)m;
                i = e.getIdentifier();
                pair = new EntityAttributePair(e, i);
                attributes.put(pair.createAttributeFileKey(), pair);
            }
            if (m instanceof Detail && (d = (Detail)m).isDetailIdentifierEnabled()) {
                i = d.getDetailIdentifier();
                pair = new EntityAttributePair(d, i);
                attributes.put(pair.createAttributeFileKey(), pair);
            }
            for (IAttribute a : m.getAttributes()) {
                pair = new EntityAttributePair(m, a);
                attributes.put(pair.createAttributeFileKey(), pair);
            }
        }
        return attributes;
    }
}

