/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import org.tmdmaker.core.model.AbstractConnectionModel;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.IVisitor;
import org.tmdmaker.core.model.IdentifierChangeListener;
import org.tmdmaker.core.model.SubsetType;

public class Entity2SubsetTypeRelationship
extends AbstractConnectionModel
implements IdentifierChangeListener {
    public Entity2SubsetTypeRelationship(AbstractEntityModel source) {
        this.setSource(source);
        this.setTarget(new SubsetType());
    }

    public IAttribute getPartitionAttribute() {
        return ((SubsetType)this.getTarget()).getPartitionAttribute();
    }

    public String getPartitionAttributeName() {
        IAttribute partitionAttribute = this.getPartitionAttribute();
        if (partitionAttribute == null) {
            return "";
        }
        if (this.isExceptNull()) {
            return "NULL(" + partitionAttribute.getName() + ")";
        }
        return partitionAttribute.getName();
    }

    @Override
    public void identifierChanged() {
        for (AbstractConnectionModel con : this.getTarget().getModelSourceConnections()) {
            if (!(con instanceof IdentifierChangeListener)) continue;
            ((IdentifierChangeListener)((Object)con)).identifierChanged();
        }
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    public boolean isExceptNull() {
        return ((SubsetType)this.getTarget()).isExceptNull();
    }

    public void firePartitionChanged() {
        this.firePropertyChange("_property_partition", null, null);
    }

    @Override
    public String getSourceName() {
        return this.getSource().getName();
    }

    @Override
    public String getTargetName() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (AbstractConnectionModel c : this.getTarget().getModelSourceConnections()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(c.getTarget().getName());
        }
        return builder.toString();
    }

    @Override
    public void connect() {
        super.connect();
        Diagram diagram = this.getSuperset().getDiagram();
        if (diagram != null) {
            diagram.addChild(this.getSubsetType());
        }
    }

    @Override
    public void disconnect() {
        Diagram diagram = this.getSubsetType().getSuperset().getDiagram();
        if (diagram != null) {
            diagram.removeChild(this.getSubsetType());
        }
        super.disconnect();
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    public SubsetType getSubsetType() {
        return (SubsetType)this.getTarget();
    }

    private AbstractEntityModel getSuperset() {
        return (AbstractEntityModel)this.getSource();
    }
}

