/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Cardinality;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.MultivalueAndAggregator;
import jp.sourceforge.tmdmaker.model.MultivalueAndSuperset;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.TransfarReuseKeysToTargetRelationship;

public class Header2DetailRelationship
extends TransfarReuseKeysToTargetRelationship {
    private MultivalueAndSuperset superset;
    private Detail detail;
    private MultivalueAndAggregator aggregator;
    private RelatedRelationship superset2aggregator;
    private RelatedRelationship header2aggregator;
    private RelatedRelationship detail2aggregator;
    private String oldHeaderName;
    private String newHeaderName;

    public Header2DetailRelationship(AbstractEntityModel header) {
        this.setSource(header);
        this.detail = Detail.build(header);
        this.setTarget(this.detail);
        this.setTargetCardinality(Cardinality.MANY);
        this.superset = MultivalueAndSuperset.build(header);
        this.superset.setDetail(this.detail);
        this.aggregator = new MultivalueAndAggregator();
        this.superset2aggregator = new RelatedRelationship(this.superset, this.aggregator);
        this.header2aggregator = new RelatedRelationship(header, this.aggregator);
        this.detail2aggregator = new RelatedRelationship(this.detail, this.aggregator);
        this.oldHeaderName = header.getName();
        this.newHeaderName = this.createHeaderName(header);
    }

    private String createHeaderName(AbstractEntityModel model) {
        return String.valueOf(model.getName()) + "HDR";
    }

    @Override
    public void connect() {
        super.connect();
        this.connectSuperset();
        this.getSource().setName(this.newHeaderName);
    }

    public void connectSuperset() {
        Diagram diagram = this.getSource().getDiagram();
        if (diagram != null) {
            diagram.addChild(this.superset);
            diagram.addChild(this.aggregator);
        }
        this.superset2aggregator.connect();
        this.header2aggregator.connect();
        this.detail2aggregator.connect();
    }

    @Override
    public void disconnect() {
        this.getSource().setName(this.oldHeaderName);
        this.disconnectSuperset();
        super.disconnect();
    }

    public void disconnectSuperset() {
        this.detail2aggregator.disconnect();
        this.header2aggregator.disconnect();
        this.superset2aggregator.disconnect();
        Diagram diagram = this.getSource().getDiagram();
        if (diagram != null) {
            diagram.removeChild(this.aggregator);
            diagram.removeChild(this.superset);
        }
    }

    public boolean isSupersetConnected() {
        return this.header2aggregator.isConnected();
    }

    @Override
    public void attachTarget() {
        Diagram diagram = this.getSource().getDiagram();
        if (diagram != null) {
            diagram.addChild(this.detail);
        }
        super.attachTarget();
    }

    @Override
    public void detachTarget() {
        super.detachTarget();
        Diagram diagram = this.getSource().getDiagram();
        if (diagram != null) {
            diagram.removeChild(this.detail);
        }
    }

    @Override
    public void identifierChanged() {
        super.identifierChanged();
        this.superset.fireIdentifierChanged(this);
    }

    @Override
    public boolean isDeletable() {
        return this.getTarget().isDeletable();
    }

    public MultivalueAndSuperset getMultivalueAndSuperset() {
        return this.superset;
    }

    public MultivalueAndAggregator getAggregator() {
        return this.aggregator;
    }

    public Detail getDetail() {
        return this.detail;
    }
}

