/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.IdentifierRef;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;

public class Detail
extends AbstractEntityModel {
    private ReusedIdentifier originalReusedIdentifier;
    private Identifier detailIdentifier = new Identifier();
    private boolean isDetailIdentifierEnabled = true;

    protected Detail() {
    }

    protected static Detail build(AbstractEntityModel header) {
        Detail detail = new Detail();
        detail.setName(String.valueOf(header.getName()) + "DTL");
        detail.setEntityType(header.getEntityType());
        detail.setOriginalReusedIdentifier(header.createReusedIdentifier());
        detail.getDetailIdentifier().copyFrom(Detail.createDetailIdentifier(header.getName()));
        ImplementRule.setModelDefaultValue(detail);
        return detail;
    }

    private static Identifier createDetailIdentifier(String headerName) {
        Identifier id = new Identifier(String.valueOf(headerName) + "\u660e\u7d30\u756a\u53f7");
        ImplementRule.setIdentifierDefaultValue(id);
        return id;
    }

    public void setDetailIdentifierName(String name) {
        String oldValue = this.detailIdentifier.getName();
        this.detailIdentifier.setName(name);
        if (oldValue == null || !oldValue.equals(name)) {
            this.firePropertyChange("_property_identifier", oldValue, name);
            this.fireIdentifierChanged(null);
        }
    }

    public Identifier getDetailIdentifier() {
        return this.detailIdentifier;
    }

    public void setDetailIdentifier(Identifier detailIdentifier) {
        Identifier oldValue = this.detailIdentifier;
        this.detailIdentifier = detailIdentifier;
        this.firePropertyChange("_property_identifier", oldValue, detailIdentifier);
    }

    public void setDetailIdentifierEnabled(boolean enabled) {
        if (this.isDetailIdentifierEnabled() == enabled) {
            return;
        }
        this.isDetailIdentifierEnabled = enabled;
        this.fireIdentifierChanged(null);
    }

    public boolean isDetailIdentifierEnabled() {
        return this.isDetailIdentifierEnabled;
    }

    public boolean canDisableDetailIdentifierEnabled() {
        return this.getReusedIdentifiers().size() > 1;
    }

    public ReusedIdentifier getOriginalReusedIdentifier() {
        return this.originalReusedIdentifier;
    }

    public IdentifierRef getOriginalUniqueIdentifierRef() {
        return this.getOriginalReusedIdentifier().getUniqueIdentifiers().get(0);
    }

    public void setOriginalReusedIdentifier(ReusedIdentifier originalReusedIdentifier) {
        this.originalReusedIdentifier = originalReusedIdentifier;
    }

    @Override
    public boolean isEntityTypeEditable() {
        return false;
    }

    @Override
    public ReusedIdentifier createReusedIdentifier() {
        ReusedIdentifier returnValue = new ReusedIdentifier(this.keyModels.getSurrogateKey());
        if (this.isDetailIdentifierEnabled) {
            if (this.originalReusedIdentifier != null) {
                returnValue.addAll(this.originalReusedIdentifier.getIdentifiers());
            }
            returnValue.addIdentifier(this.detailIdentifier);
        } else {
            for (Map.Entry ref : this.reusedIdentifiers.entrySet()) {
                returnValue.addAll(((ReusedIdentifier)ref.getValue()).getIdentifiers());
            }
        }
        return returnValue;
    }

    @Override
    public boolean isDeletable() {
        return this.getModelSourceConnections().size() == 1 && this.getModelTargetConnections().size() == 1;
    }

    @Override
    public void copyTo(AbstractEntityModel to) {
        Detail toDetail = (Detail)to;
        toDetail.setDetailIdentifierEnabled(this.isDetailIdentifierEnabled());
        toDetail.setDetailIdentifierName(this.getDetailIdentifier().getName());
        toDetail.getDetailIdentifier().copyFrom(this.getDetailIdentifier());
        super.copyTo(to);
    }

    @Override
    public Detail getCopy() {
        Detail copy = new Detail();
        this.copyTo(copy);
        return copy;
    }

    @Override
    public int calcurateMaxIdentifierRefSize() {
        int di = this.detailIdentifier.getName().length();
        int oi = this.calcurateMaxOriginalIdentifierRefSize();
        int imax = Math.max(di, oi);
        return Math.max(imax, super.calcurateMaxIdentifierRefSize());
    }

    private int calcurateMaxOriginalIdentifierRefSize() {
        int i = 0;
        for (IdentifierRef ir : this.originalReusedIdentifier.getUniqueIdentifiers()) {
            i = Math.max(ir.getName().length(), i);
        }
        return i;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }
}

