/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.generate.relationshiplist;

import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.RecursiveRelationship;
import jp.sourceforge.tmdmaker.model.RecursiveTable;

public class RelationshipMapping {
    private AbstractEntityModel source;
    private AbstractEntityModel target;
    private boolean relationship = false;

    public RelationshipMapping(AbstractEntityModel source, AbstractEntityModel target) {
        this.source = source;
        this.target = target;
        this.relationship = this.hasRecursiveRelationship() ? true : (this.hasRelationshipAsSource() ? true : this.hasRelationshipAsTarget());
        if (this.isRecursiveTablePair()) {
            this.relationship = false;
        }
    }

    private boolean isRecursiveTablePair() {
        if (this.target instanceof RecursiveTable) {
            return ((RecursiveTable)this.target).isSource(this.source);
        }
        if (this.source instanceof RecursiveTable) {
            return ((RecursiveTable)this.source).isSource(this.target);
        }
        return false;
    }

    private boolean hasRecursiveRelationship() {
        if (this.source == this.target) {
            for (AbstractConnectionModel connection : this.source.getModelSourceConnections()) {
                if (!(connection instanceof RecursiveRelationship)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasRelationshipAsSource() {
        boolean hasRelationship = false;
        for (AbstractConnectionModel connection : this.source.getModelSourceConnections()) {
            if (!connection.getTarget().equals(this.target)) continue;
            hasRelationship = true;
            break;
        }
        return hasRelationship;
    }

    private boolean hasRelationshipAsTarget() {
        boolean hasRelationship = false;
        for (AbstractConnectionModel connection : this.source.getModelTargetConnections()) {
            if (!connection.getSource().equals(this.target)) continue;
            hasRelationship = true;
            break;
        }
        return hasRelationship;
    }

    public boolean isRelationship() {
        return this.relationship;
    }

    public AbstractEntityModel getSource() {
        return this.source;
    }

    public AbstractEntityModel getTarget() {
        return this.target;
    }
}

