/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpolicy;

import jp.sourceforge.tmdmaker.editpart.AbstractEntityEditPart;
import jp.sourceforge.tmdmaker.editpart.XYChopboxAnchorHelper;
import jp.sourceforge.tmdmaker.editpolicy.TMDModelGraphicalNodeEditPolicy;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.ui.command.SourceConnectionReconnectCommand;
import jp.sourceforge.tmdmaker.ui.command.TargetConnectionReconnectCommand;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectableNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected static Logger logger = LoggerFactory.getLogger(TMDModelGraphicalNodeEditPolicy.class);

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        AbstractConnectionModel connection = (AbstractConnectionModel)request.getConnectionEditPart().getModel();
        if (connection.getSource() == connection.getTarget()) {
            System.out.println("source == target");
            return null;
        }
        AbstractEntityModel newSource = (AbstractEntityModel)request.getTarget().getModel();
        if (!connection.getSource().equals(newSource)) {
            System.out.println("source not equals newSource");
            return null;
        }
        Point location = new Point(request.getLocation());
        AbstractEntityEditPart sourceEditPart = (AbstractEntityEditPart)request.getConnectionEditPart().getSource();
        IFigure sourceFigure = sourceEditPart.getFigure();
        sourceFigure.translateToRelative((Translatable)location);
        int xp = -1;
        int yp = -1;
        Rectangle bounds = sourceFigure.getBounds();
        Rectangle centerRectangle = new Rectangle(bounds.x + bounds.width / 4, bounds.y + bounds.height / 4, bounds.width / 2, bounds.height / 2);
        if (!centerRectangle.contains(location)) {
            System.out.println("not center");
            Point point = new XYChopboxAnchorHelper(bounds).getIntersectionPoint(location);
            xp = 100 * (point.x - bounds.x) / bounds.width;
            yp = 100 * (point.y - bounds.y) / bounds.height;
        }
        return new SourceConnectionReconnectCommand(connection, xp, yp);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        AbstractConnectionModel connection = (AbstractConnectionModel)request.getConnectionEditPart().getModel();
        if (connection.getSource() == connection.getTarget()) {
            System.out.println("source == target");
            return null;
        }
        AbstractEntityModel newTarget = (AbstractEntityModel)request.getTarget().getModel();
        if (!connection.getTarget().equals(newTarget)) {
            System.out.println("target not equals newTarget");
            return null;
        }
        Point location = new Point(request.getLocation());
        AbstractEntityEditPart targetEditPart = (AbstractEntityEditPart)request.getConnectionEditPart().getTarget();
        IFigure targetFigure = targetEditPart.getFigure();
        targetFigure.translateToRelative((Translatable)location);
        int xp = -1;
        int yp = -1;
        Rectangle bounds = targetFigure.getBounds();
        Rectangle centerRectangle = new Rectangle(bounds.x + bounds.width / 4, bounds.y + bounds.height / 4, bounds.width / 2, bounds.height / 2);
        if (!centerRectangle.contains(location)) {
            System.out.println("not center");
            Point point = new XYChopboxAnchorHelper(bounds).getIntersectionPoint(location);
            xp = 100 * (point.x - bounds.x) / bounds.width;
            yp = 100 * (point.y - bounds.y) / bounds.height;
        }
        return new TargetConnectionReconnectCommand(connection, xp, yp);
    }

    protected AbstractEntityModel getAbstractEntityModel() {
        return (AbstractEntityModel)this.getHost().getModel();
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        return null;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        return null;
    }
}

