/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Entity2SubsetTypeRelationship;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.SubsetEntity;

public class SubsetType
extends ConnectableElement {
    private SubsetTypeValue subsetType = SubsetTypeValue.SAME;
    public static final String PROPERTY_PARTITION = "_property_partition";
    public static final String PROPERTY_TYPE = "_property_type";
    public static final String PROPERTY_DIRECTION = "_property_direction";
    private IAttribute partitionAttribute;
    private boolean exceptNull;
    private boolean vertical = false;

    public List<SubsetEntity> findSubsetEntityList() {
        ArrayList<SubsetEntity> results = new ArrayList<SubsetEntity>();
        for (AbstractConnectionModel c : this.getModelSourceConnections()) {
            if (!(c instanceof RelatedRelationship)) continue;
            results.add((SubsetEntity)c.getTarget());
        }
        return results;
    }

    public SubsetTypeValue getSubsetType() {
        return this.subsetType;
    }

    public void setSubsetType(SubsetTypeValue subsetType) {
        SubsetTypeValue oldValue = this.subsetType;
        this.subsetType = subsetType;
        this.firePropertyChange(PROPERTY_TYPE, (Object)oldValue, (Object)this.subsetType);
    }

    public IAttribute getPartitionAttribute() {
        return this.partitionAttribute;
    }

    public void setPartitionAttribute(IAttribute partitionAttribute) {
        IAttribute oldValue = this.partitionAttribute;
        this.partitionAttribute = partitionAttribute;
        this.firePropertyChange(PROPERTY_PARTITION, oldValue, partitionAttribute);
        this.firePartitionChanged();
    }

    public boolean isExceptNull() {
        return this.exceptNull;
    }

    public void setExceptNull(boolean exceptNull) {
        boolean oldValue = this.exceptNull;
        this.exceptNull = exceptNull;
        this.firePropertyChange(PROPERTY_PARTITION, oldValue, this.partitionAttribute);
        this.firePartitionChanged();
    }

    public void firePartitionChanged() {
        if (this.getModelTargetConnections().size() > 0) {
            ((Entity2SubsetTypeRelationship)this.getModelTargetConnections().get(0)).firePartitionChanged();
        }
    }

    public boolean isSameType() {
        return this.subsetType.equals((Object)SubsetTypeValue.SAME);
    }

    public void dispose() {
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        boolean oldValue = this.vertical;
        this.vertical = vertical;
        this.firePropertyChange(PROPERTY_DIRECTION, oldValue, this.vertical);
    }

    public static enum SubsetTypeValue {
        SAME,
        DIFFERENT;

    }
}

