/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.CombinationTable;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.rule.RelationshipRule;

public class Resource2ResourceRelationship
extends AbstractRelationship {
    private CombinationTable table;
    private RelatedRelationship combinationTableConnection;
    private ReusedIdentifier sourceReuseIdentifier;
    private ReusedIdentifier targetReuseIdentifier;

    public Resource2ResourceRelationship(AbstractEntityModel source, AbstractEntityModel target) {
        this.setSource(source);
        this.setTarget(target);
        this.table = RelationshipRule.createCombinationTable(source, target);
        this.table.setConstraint(source.getConstraint().getTranslated(100, 100));
        this.combinationTableConnection = new RelatedRelationship(this, this.table);
        this.setCenterMark(true);
    }

    @Override
    public void connect() {
        super.connect();
        this.getSource().getDiagram().addChild(this.table);
        this.combinationTableConnection.connect();
        if (this.sourceReuseIdentifier == null) {
            this.table.addReusedIdentifier(this.getSource());
        } else {
            this.table.addReusedIdentifier(this.getSource(), this.sourceReuseIdentifier);
            this.sourceReuseIdentifier = null;
        }
        if (this.targetReuseIdentifier == null) {
            this.table.addReusedIdentifier(this.getTarget());
        } else {
            this.table.addReusedIdentifier(this.getTarget(), this.targetReuseIdentifier);
            this.targetReuseIdentifier = null;
        }
    }

    @Override
    public void disconnect() {
        this.sourceReuseIdentifier = this.table.removeReusedIdentifier(this.getSource());
        this.targetReuseIdentifier = this.table.removeReusedIdentifier(this.getTarget());
        this.combinationTableConnection.disconnect();
        this.getSource().getDiagram().removeChild(this.table);
        super.disconnect();
    }

    @Override
    public boolean isDeletable() {
        return this.table.isDeletable();
    }

    @Override
    public void identifierChanged() {
        this.table.fireIdentifierChanged(this);
    }
}

