/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker;

import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.ui.preferences.IPreferenceListener;
import jp.sourceforge.tmdmaker.ui.preferences.appearance.AppearancePreferenceListener;
import jp.sourceforge.tmdmaker.ui.preferences.rule.RulePreferenceListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TMDPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "tmdmaker";
    private static TMDPlugin plugin;
    private IPropertyChangeListener[] listeners = new IPropertyChangeListener[]{new AppearancePreferenceListener(), new RulePreferenceListener()};

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IPreferenceStore store = plugin.getPreferenceStore();
        IPropertyChangeListener[] iPropertyChangeListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyChangeListener listener = iPropertyChangeListenerArray[n2];
            if (listener instanceof IPreferenceListener) {
                ((IPreferenceListener)listener).preferenceStart(store);
            }
            store.addPropertyChangeListener(listener);
            ++n2;
        }
        this.update();
    }

    public void stop(BundleContext context) throws Exception {
        IPreferenceStore store = plugin.getPreferenceStore();
        IPropertyChangeListener[] iPropertyChangeListenerArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyChangeListener listener = iPropertyChangeListenerArray[n2];
            store.removePropertyChangeListener(listener);
            ++n2;
        }
        super.stop(context);
        plugin = null;
    }

    public static TMDPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return TMDPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void log(Throwable t) {
        Status status = new Status(4, PLUGIN_ID, 4, t.getMessage(), t);
        TMDPlugin.getDefault().getLog().log((IStatus)status);
        t.printStackTrace();
    }

    public static void showMessageDialog(String message) {
        MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 34);
        messageBox.setText("\u60c5\u5831");
        messageBox.setMessage(message);
        messageBox.open();
    }

    public static void showErrorDialog(Throwable t) {
        TMDPlugin.showErrorDialog("\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", t);
    }

    public static void showErrorDialog(String message, Throwable t) {
        Status status = new Status(4, PLUGIN_ID, 0, t.getMessage(), t);
        TMDPlugin.log(t);
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"\u30a8\u30e9\u30fc", (String)message, (IStatus)status);
    }

    public static Image getImage(String path) {
        ImageRegistry images = TMDPlugin.getDefault().getImageRegistry();
        Image image = images.get(path);
        if (image == null) {
            image = TMDPlugin.getImageDescriptor(path).createImage();
            images.put(path, image);
        }
        return image;
    }

    public void update() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = w.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference ref = iEditorReferenceArray[n6];
                    IEditorPart part = ref.getEditor(false);
                    if (part instanceof TMDEditor) {
                        ((TMDEditor)part).updateVisuals();
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }
}

