/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "repinfo.h"
#include <limits.h>
#include "resource.h"
#include "wcommon.h"


/******************************************************************************
*                                                                             *
* ja:置換情報ダイアログ群                                                     *
*                                                                             *
******************************************************************************/
BOOL CALLBACK RepinfoDlgProc(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
  static POINT ptDlg = {INT_MIN, INT_MIN};/* ja:ダイアログの表示位置 */

  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          LPTSTR lpszFormat, lpszText;
          HINSTANCE hInstance;
          LPREPINFODLG lpDlg;

          lpDlg = (LPREPINFODLG)lParam;
          hInstance = GetModuleHandle (NULL);
          if (ptDlg.x != INT_MIN && ptDlg.y != INT_MIN)
            SetWindowPos (hDlg,
                        0, ptDlg.x, ptDlg.y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);
          SetDlgItemText (hDlg, IDC_STATICA1, lpDlg->lpszSrc);
          SetDlgItemText (hDlg, IDC_STATICA2, lpDlg->lpszDst);
          lpszFormat = LoadText (hInstance, IDS_REPINFO_SELECT);
          wasprintf (&lpszText, lpszFormat,
                                    lpDlg->ptStart.x + 1, lpDlg->ptStart.y + 1,
                                    lpDlg->ptEnd.x + 1,   lpDlg->ptEnd.y + 1);
          MemoryFree (lpszFormat);
          SetDlgItemText (hDlg, IDC_STATICA3, lpszText);
          MemoryFree (lpszText);
          lpszText = LoadText (hInstance, lpDlg->bCase
                                        ? IDS_REPINFO_BS0 : IDS_REPINFO_BS1);
          SetDlgItemText (hDlg, IDC_STATICA4, lpszText);
          MemoryFree (lpszText);
          lpszText = LoadText (hInstance, lpDlg->bWidth
                                        ? IDS_REPINFO_FH0 : IDS_REPINFO_FH1);
          SetDlgItemText (hDlg, IDC_STATICA5, lpszText);
          MemoryFree (lpszText);
          lpszText = LoadText (hInstance, lpDlg->bArrow
                                        ? IDS_REPINFO_UD0 : IDS_REPINFO_UD1);
          SetDlgItemText (hDlg, IDC_STATICA6, lpszText);
          MemoryFree (lpszText);
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDC_PUSHBUTTONA1:
            case IDYES:
            case IDNO:
            case IDCANCEL:
              {
                RECT rc;

                if (GetWindowRect (hDlg, &rc))
                  {
                    ptDlg.x = rc.left;
                    ptDlg.y = rc.top;
                  }
                EndDialog (hDlg, LOWORD (wParam));
              }
          }
        return TRUE;
    }
  return FALSE;
}
