/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __HISTORY_H__
#define __HISTORY_H__


#include "tmaid.h"


#ifdef __cplusplus
extern "C" {
#endif


/******************************************************************************
*                                                                             *
* ja:ファイルの履歴関数                                                       *
*                                                                             *
******************************************************************************/
/*  ja:ファイルの履歴に加える
     lpszFile,ファイル名
         hWnd,ウインドウ
     nHistory,最大履歴数
     nMenuTop,トップメニューの項目数
    nMenuFile,ファイルの項目の数                                            */
VOID
SetHistory (LPCTSTR lpszFile,
            HWND    hWnd,
            int     nHistory,
            int     nMenuTop,
            int     nMenuFile);


/*  ja:ファイルの履歴を取得する
     hWnd,ウインドウ
    uItem,コマンド項目
      RET,ファイル名,NULL:エラー                                            */
LPTSTR
GetHistory (HWND hWnd,
            UINT uItem);


/*  ja:最大履歴数を変更する
         hWnd,親ウインドウ
     nHistory,最大履歴数
     nMenuTop,トップメニューの項目数
    nMenuFile,ファイルの項目の数                                            */
VOID
ModifyHistory (HWND hWnd,
               int  nHistory,
               int  nMenuTop,
               int  nMenuFile);


/*  ja:最大履歴数を変更する
             hInst,インスタンスハンドル
    lpTemplateName,テンプレート名
              hWnd,親ウインドウ
          nHistory,最大履歴数
          nMenuTop,トップメニューの項目数
         nMenuFile,ファイルの項目の数
               RET,最大履歴数                                               */
int
ModifyHistoryDlg (HINSTANCE hInst,
                  LPCTSTR   lpTemplateName,
                  HWND      hWnd,
                  int       nHistory,
                  int       nMenuTop,
                  int       nMenuFile);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __HISTORY_H__ */
