;copyright (c) 2017-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org
;
;Permission is hereby granted, free of charge, to any person obtaining
;a copy of this software and associated documentation files (the
;"Software"), to deal in the Software without restriction, including
;without limitation the rights to use, copy, modify, merge, publish,
;distribute, sublicense, and/or sell copies of the Software, and to
;permit persons to whom the Software is furnished to do so, subject to
;the following conditions:
;
;The above copyright notice and this permission notice shall be included
;in all copies or substantial portions of the Software.
;
;THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
;EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
;CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
;TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
;SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

.586
.model flat, c


NULL                                 equ 0
DEFAULT_SECURITY_COOKIE              equ 0BB40E64Eh
STATUS_SECURITY_CHECK_FAILURE        equ STATUS_STACK_BUFFER_OVERRUN
STATUS_STACK_BUFFER_OVERRUN          equ 0C0000409h
EXCEPTION_MAXIMUM_PARAMETERS         equ 15
EXCEPTION_NONCONTINUABLE             equ 1
FAST_FAIL_STACK_COOKIE_CHECK_FAILURE equ 2
SIZE_OF_80387_REGISTERS              equ 80
MAXIMUM_SUPPORTED_EXTENSION          equ 512
CONTEXT_i386                         equ 00010000h
CONTEXT_CONTROL                      equ (CONTEXT_i386 or 00000001h)
CONTEXT_INTEGER                      equ (CONTEXT_i386 or 00000002h)
CONTEXT_SEGMENTS                     equ (CONTEXT_i386 or 00000004h)
CONTEXT_FULL                         equ (CONTEXT_CONTROL or CONTEXT_INTEGER or CONTEXT_SEGMENTS)


EXCEPTION_RECORD struct
ExceptionCode        dd                 ?
ExceptionFlags       dd                 ?
ExceptionRecord      dd                 ?
ExceptionAddress     dd                 ?
NumberParameters     dd                 ?
ExceptionInformation dd                 EXCEPTION_MAXIMUM_PARAMETERS dup (?)
EXCEPTION_RECORD ends


FLOATING_SAVE_AREA struct
ControlWord          dd                 ?
StatusWord           dd                 ?
TagWord              dd                 ?
ErrorOffset          dd                 ?
ErrorSelector        dd                 ?
DataOffset           dd                 ?
DataSelector         dd                 ?
RegisterArea         db                 SIZE_OF_80387_REGISTERS dup (?)
Cr0NpxState          dd                 ?
FLOATING_SAVE_AREA ends


CONTEXT struct
ContextFlags         dd                 ?
RegDr0               dd                 ?
RegDr1               dd                 ?
RegDr2               dd                 ?
RegDr3               dd                 ?
RegDr6               dd                 ?
RegDr7               dd                 ?
FloatSave            FLOATING_SAVE_AREA <?>
SegGs                dd                 ?
SegFs                dd                 ?
SegEs                dd                 ?
SegDs                dd                 ?
RegEdi               dd                 ?
RegEsi               dd                 ?
RegEbx               dd                 ?
RegEdx               dd                 ?
RegEcx               dd                 ?
RegEax               dd                 ?
RegEbp               dd                 ?
RegEip               dd                 ?
SegCs                dd                 ?
EFlags               dd                 ?
RegEsp               dd                 ?
SegSs                dd                 ?
ExtendedRegisters    db                 MAXIMUM_SUPPORTED_EXTENSION dup (?)
CONTEXT ends


EXCEPTION_POINTERS struct
ExceptionRecord      dd                 ?
ContextRecord        dd                 ?
EXCEPTION_POINTERS ends


SetUnhandledExceptionFilter proto stdcall, lpTopLevelExceptionFilter:dword
UnhandledExceptionFilter proto stdcall, ExceptionInfo:dword
ExitProcess proto stdcall, uExitCode:dword


.data


public __security_cookie
__security_cookie dd DEFAULT_SECURITY_COOKIE


.code


@__security_check_cookie@4 proc syscall
        cmp     ecx, DEFAULT_SECURITY_COOKIE
        jz      @@0
        pushfd
        sub     esp, sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS + sizeof CONTEXT
        mov     [esp + CONTEXT.RegEax + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], eax
        mov     [esp + CONTEXT.RegEcx + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], ecx
        mov     [esp + CONTEXT.RegEdx + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], edx
        mov     [esp + CONTEXT.RegEbx + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], ebx
        mov     [esp + CONTEXT.RegEbp + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], ebp
        mov     [esp + CONTEXT.RegEsi + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], esi
        mov     [esp + CONTEXT.RegEdi + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], edi
        mov     word ptr [esp + CONTEXT.SegSs + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], ss
        mov     word ptr [esp + CONTEXT.SegCs + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], cs
        mov     word ptr [esp + CONTEXT.SegDs + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], ds
        mov     word ptr [esp + CONTEXT.SegEs + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], es
        mov     word ptr [esp + CONTEXT.SegFs + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], fs
        mov     word ptr [esp + CONTEXT.SegGs + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], gs
        mov     eax, [esp + sizeof EXCEPTION_RECORD + sizeof CONTEXT + sizeof EXCEPTION_POINTERS]
        mov     [esp + CONTEXT.EFlags + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], eax
        lea     eax, [esp + sizeof EXCEPTION_RECORD + sizeof CONTEXT + sizeof EXCEPTION_POINTERS + sizeof dword]
        mov     [esp + CONTEXT.RegEsp + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], eax
        mov     eax, [eax]
        mov     [esp + CONTEXT.RegEip + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], eax
        mov     [esp + CONTEXT.ContextFlags + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS], CONTEXT_FULL
        mov     [esp + EXCEPTION_RECORD.ExceptionCode + sizeof EXCEPTION_POINTERS], STATUS_SECURITY_CHECK_FAILURE
        mov     [esp + EXCEPTION_RECORD.ExceptionFlags + sizeof EXCEPTION_POINTERS], EXCEPTION_NONCONTINUABLE
        mov     [esp + EXCEPTION_RECORD.ExceptionAddress + sizeof EXCEPTION_POINTERS], eax
        mov     [esp + EXCEPTION_RECORD.NumberParameters + sizeof EXCEPTION_POINTERS], 1
        mov     [esp + EXCEPTION_RECORD.ExceptionInformation + sizeof EXCEPTION_POINTERS], FAST_FAIL_STACK_COOKIE_CHECK_FAILURE
        lea     eax, [esp + sizeof EXCEPTION_POINTERS]
        mov     [esp + EXCEPTION_POINTERS.ExceptionRecord], eax
        lea     eax, [esp + sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS]
        mov     [esp + EXCEPTION_POINTERS.ContextRecord], eax
        invoke  SetUnhandledExceptionFilter, NULL
        invoke  UnhandledExceptionFilter, esp
        add     esp, sizeof EXCEPTION_RECORD + sizeof EXCEPTION_POINTERS + sizeof CONTEXT + sizeof dword
        invoke  ExitProcess, STATUS_STACK_BUFFER_OVERRUN
@@0:    ret
@__security_check_cookie@4 endp


end
