/*
    other
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "other.h"
#include "common.h"


/******************************************************************************
*                                                                             *
* ja:჌x֐Q                                                           *
*                                                                             *
******************************************************************************/
/*  ja:WXg̃L[̒l擾
             hKey,L[̃nh
    lpszValueName,L[̖O
           lpData,f[^󂯎obt@
           dwData,f[^̃TCY
              RET,ERROR_SUCCESS:I                                    */
LONG WINAPI
RegGetValueEx (HKEY   hKey,
               LPTSTR lpszValueName,
               LPVOID lpData,
               DWORD  dwData)
{
  return RegQueryValueEx (hKey, lpszValueName, NULL, NULL, lpData, &dwData);
}


/*  ja:\[X當ǂݍ
    hInstance,CX^X
          uID,ID
          RET,                                                        */
LPTSTR WINAPI
LoadText (HINSTANCE hInstance,
          UINT      uID)
{
  LPWSTR lpszText = NULL;
  int nResult, nSize = 0;

  do
    {
      nSize += 4096;
      lpszText = MemoryReAlloc (lpszText, nSize * sizeof (TCHAR));
      nResult = LoadString (hInstance, uID, lpszText, nSize);
    }
  while (nResult <= 0 || nResult >= nSize - 1);
  if (nResult > 0)
    lpszText = MemoryReAlloc (lpszText, (nResult + 1) * sizeof (TCHAR));
  else
    MemoryFree (lpszText);
  return lpszText;
}


/*  ja:XN[o[ݒ肷
     hWnd,EChE
     nBar,XN[o[^Cv
     nMin,ŏl
     nMax,ől
    nPage,y[W
     nPos,ʒu                                                              */
VOID WINAPI
SetScrollBar (HWND hWnd,
              int  nBar,
              int  nMin,
              int  nMax,
              UINT nPage,
              int  nPos)
{
  SCROLLINFO si;

  si.cbSize = sizeof (SCROLLINFO);
  si.fMask = SIF_PAGE | SIF_POS | SIF_RANGE | SIF_DISABLENOSCROLL;
  si.nMin = nMin;
  si.nMax = nMax;
  si.nPage = nPage;
  si.nPos = nPos;
  SetScrollInfo (hWnd, nBar, &si, TRUE);
}
