/*
    Text maid for Windows
    copyright (c) 1998-2018 Kazuki Iwamoto https://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "format.h"
#include <commctrl.h>
#include "common.h"
#include "dialog.h"
#include "general.h"
#include "property.h"
#include "resource.h"


/******************************************************************************
*                                                                             *
* ja:tH[}bg֐Q                                                       *
*                                                                             *
******************************************************************************/
BOOL CALLBACK
FormatDlgProc (HWND   hDlg,
               UINT   uMsg,
               WPARAM wParam,
               LPARAM lParam)
{
  static int nPos;

  if (uMsg == uDlMsg)
    {
      switch (((LPDRAGLISTINFO)lParam)->uNotification)
        {
          case DL_DRAGGING:
            return 0;
          case DL_DROPPED:
            {
              int nItem;
              FILETYPE stFType;

              nItem = LBItemFromPt (((LPDRAGLISTINFO)lParam)->hWnd,
                                    ((LPDRAGLISTINFO)lParam)->ptCursor, TRUE);
              if (nItem == -1 || nPos == nItem)
                break;
              stFType = lpFileType[nPos];
              if (nItem < nPos)
                MemoryCopy (&lpFileType[nItem + 1], &lpFileType[nItem],
                                        (nPos - nItem) * sizeof (FILETYPE));
              else
                MemoryCopy (&lpFileType[nPos], &lpFileType[nPos + 1],
                                        (nItem - nPos) * sizeof (FILETYPE));
              lpFileType[nItem] = stFType;
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_DELETESTRING,
                                                                    nPos, 0);
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_INSERTSTRING,
                                                nItem, (LPARAM)stFType.szText);
              nPos = nItem;
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL, nItem, 0);
              dwFilter = 0;
            }
        }
      return TRUE;
    }
  switch (uMsg)
    {
      case WM_INITDIALOG:
        {
          int i;
          HWND hWnd;

          nPos = dwFilter;
          if (nPos >= nFileType)
            nPos = 0;
          /* ja:Xg{bNXݒ肷 */
          for (i = 0; i < nFileType; i++)
            SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_ADDSTRING,
                                            0, (LPARAM)lpFileType[i].szText);
          SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL, nPos, 0);
          hWnd = GetDlgItem (hDlg, IDC_LISTBOXE1);
          if (!hWnd)
            {
              MessageBox (hDlg, _T("GetDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          if (!MakeDragList (hWnd))
            {
              MessageBox (hDlg, _T("MakeDragList"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
              return TRUE;
            }
          /* ja:Rg[̕\ */
          if (!EnableDlgItem (hDlg, IDC_PUSHBUTTONE2, nFileType > 1)
            || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE3, nPos > 0)
            || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE4, nPos < nFileType - 1))
            {
              MessageBox (hDlg, _T("EnableDlgItem"),
                                APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              EndDialog (hDlg, IDCANCEL);
            }
        }
        return TRUE;
      case WM_COMMAND:
        switch (LOWORD (wParam))
          {
            case IDCANCEL:
              if (!EndDialog (hDlg, LOWORD (wParam)))
                MessageBox (hDlg, _T("EndDialog"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
              return TRUE;
            case IDC_PUSHBUTTONE1:/* ja:VK */
              lpFileType = MemoryReAlloc (lpFileType,
                                            ++nFileType * sizeof (FILETYPE));
              MemoryCopy (&lpFileType[nPos + 2], &lpFileType[nPos + 1],
                                (nFileType - nPos - 2) * sizeof (FILETYPE));
              lpFileType[nPos + 1] = lpFileType[nPos];
              lpFileType[nPos + 1].nID = nTypeCount++;
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_INSERTSTRING,
                                    nPos + 1, (LPARAM)lpFileType[nPos].szText);
              /* ja:Rg[̕\ */
              if (!EnableDlgItem (hDlg, IDC_PUSHBUTTONE2, TRUE)
                            || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE4, TRUE))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                }
              return TRUE;
            case IDC_PUSHBUTTONE2:/* ja:폜 */
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_DELETESTRING,
                                                                    nPos, 0);
              MemoryCopy (&lpFileType[nPos], &lpFileType[nPos + 1],
                                (nFileType - nPos - 1) * sizeof (FILETYPE));
              lpFileType = MemoryReAlloc (lpFileType,
                                            --nFileType * sizeof (FILETYPE));
              if (nPos > nFileType - 1)
                nPos = nFileType - 1;
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL, nPos, 0);
              /* ja:Rg[̕\ */
              if (!EnableDlgItem (hDlg, IDC_PUSHBUTTONE2, nFileType > 1)
                || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE3, nPos > 0)
                || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE4,
                                                        nPos < nFileType - 1))
                {
                  MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                  EndDialog (hDlg, IDCANCEL);
                }
              dwFilter = 0;
              return TRUE;
            case IDC_PUSHBUTTONE3:/* ja: */
              {
                FILETYPE stFType;

                stFType = lpFileType[nPos];
                lpFileType[nPos] = lpFileType[nPos - 1];
                lpFileType[nPos - 1] = stFType;
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_DELETESTRING,
                                                                    nPos, 0);
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_INSERTSTRING,
                                            --nPos, (LPARAM)stFType.szText);
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL,
                                                                    nPos, 0);
                dwFilter = 0;
              }
              return TRUE;
            case IDC_PUSHBUTTONE4:/* ja: */
              {
                FILETYPE stFType;

                stFType = lpFileType[nPos];
                lpFileType[nPos] = lpFileType[nPos + 1];
                lpFileType[nPos + 1] = stFType;
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_DELETESTRING,
                                                                    nPos, 0);
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_INSERTSTRING,
                                            ++nPos, (LPARAM)stFType.szText);
                SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL,
                                                                    nPos, 0);
                dwFilter = 0;
              }
              return TRUE;
            case IDC_LISTBOXE1:/* ja:ҏW */
              if (HIWORD (wParam) == LBN_SELCHANGE)
                {
                  nPos = SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_GETCURSEL,
                                                                        0, 0);
                  /* ja:Rg[̕\ */
                  if (!EnableDlgItem (hDlg, IDC_PUSHBUTTONE3, nPos > 0)
                                    || !EnableDlgItem (hDlg, IDC_PUSHBUTTONE4,
                                                        nPos < nFileType - 1))
                    {
                      MessageBox (hDlg, _T("EnableDlgItem"),
                                    APPLICATION, MB_OK | MB_ICONEXCLAMATION);
                      EndDialog (hDlg, IDCANCEL);
                    }
                  return TRUE;
                }
              else if (HIWORD (wParam) != LBN_DBLCLK)
                {
                  return 1;
                }
            case IDC_PUSHBUTTONE5:
              if (DialogBoxParamGUI (hInst, MAKEINTRESOURCE (DIALOG_D), hDlg,
                        PropertyDlgProc, (LPARAM)&lpFileType[nPos]) != IDOK)
                return TRUE;
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_INSERTSTRING,
                                        nPos, (LPARAM)lpFileType[nPos].szText);
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_DELETESTRING,
                                                                nPos + 1, 0);
              SendDlgItemMessage (hDlg, IDC_LISTBOXE1, LB_SETCURSEL, nPos, 0);
              EnumChildWindows (hWndClient, PropertyEnumProc,
                                                    (LPARAM)&lpFileType[nPos]);
          }
        return TRUE;
    }
  return FALSE;
}
