/*
    Text maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "charset.h"
#include "edit.h"
#include "general.h"
#include "sigfile.h"
#include "sigkey.h"
#include "misc/misc.h"
#include "orz/orzmdi.h"


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(テキスト)                                        *
*                                                                             *
******************************************************************************/
gboolean
signal_key_press (GtkWidget   *widget,
                  GdkEventKey *event,
                  TmaidWindow *tmaid)
{
  gboolean result = FALSE;/* TRUE:処理終了,FALSE:処理継続 */

  if (gtk_im_context_filter_keypress (tmaid->im_context, event))
    return TRUE;
  switch (event->keyval)
    {
      case GDK_Home:
      case GDK_KP_Home:
      case GDK_End:
      case GDK_KP_End:
      case GDK_H:
      case GDK_h:
      case GDK_Left:
      case GDK_KP_Left:
      case GDK_L:
      case GDK_l:
      case GDK_Right:
      case GDK_KP_Right:
      case GDK_comma:
      case GDK_less:
      case GDK_period:
      case GDK_greater:
      case GDK_K:
      case GDK_k:
      case GDK_Up:
      case GDK_KP_Up:
      case GDK_J:
      case GDK_j:
      case GDK_Down:
      case GDK_KP_Down:
      case GDK_Page_Up:
      case GDK_KP_Page_Up:
      case GDK_Page_Down:
      case GDK_KP_Page_Down:
        {
          gint max, sx, sy, width;
          gboolean alt, ctrl;
          GdkPoint cursor, top, select;

          cursor = tmaid->cursor;
          top = tmaid->top;
          sx = MAX (tmaid->drawing->allocation.width / tmaid->font_width, 1);
          sy = MAX (tmaid->drawing->allocation.height / tmaid->font_height, 1);
          alt = event->state & GDK_MOD1_MASK;
          ctrl = event->state & GDK_CONTROL_MASK;
          switch (event->keyval)
            {
              case GDK_Home:
              case GDK_KP_Home:
                tmaid->cursor.x = 0;
                if (ctrl)
                  tmaid->cursor.y = 0;
                break;
              case GDK_End:
              case GDK_KP_End:
                tmaid->cursor.x = edit_get_width (tmaid,
                    ctrl ? tmaid->cursor.y = tmaid->max - 1 : tmaid->cursor.y);
                break;
              case GDK_H:
              case GDK_h:
                if (!alt)
                  return result;
              case GDK_Left:
              case GDK_KP_Left:
                tmaid->cursor.x = edit_get_align_pos (tmaid,
                                    tmaid->cursor.x, tmaid->cursor.y, FALSE);
                if (tmaid->cursor.x > 0)
                  {
                    tmaid->cursor.x = ctrl ? edit_get_move_pos (tmaid,
                                    tmaid->cursor.x, tmaid->cursor.y, FALSE)
                            : edit_get_align_pos (tmaid,
                                tmaid->cursor.x - 1, tmaid->cursor.y, FALSE);
                  }
                else if (tmaid->cursor.y > 0)
                  {
                    /* ja:前の行の最後 */
                    tmaid->cursor.y--;
                    tmaid->cursor.x = edit_get_width (tmaid, tmaid->cursor.y);
                  }
                break;
              case GDK_L:
              case GDK_l:
                if (!alt)
                  return result;
              case GDK_Right:
              case GDK_KP_Right:
                width = edit_get_width (tmaid, tmaid->cursor.y);
                if (tmaid->cursor.x < width)
                  {
                    tmaid->cursor.x = ctrl ? edit_get_move_pos (tmaid,
                                        tmaid->cursor.x, tmaid->cursor.y, TRUE)
                            : edit_get_align_pos (tmaid,
                                tmaid->cursor.x + 1, tmaid->cursor.y, TRUE);
                  }
                else if (tmaid->cursor.y < tmaid->max - 1)
                  {
                    /* ja:次の行の最初 */
                    tmaid->cursor.x = 0;
                    tmaid->cursor.y++;
                  }
                break;
              case GDK_comma:
              case GDK_less:
                if (!ctrl)
                  break;
                tmaid->cursor.x = edit_get_align_pos (tmaid,
                                    tmaid->cursor.x, tmaid->cursor.y, FALSE);
                if (tmaid->cursor.x > 0)
                  {
                    tmaid->cursor.x = edit_get_move_pos (tmaid,
                                    tmaid->cursor.x, tmaid->cursor.y, FALSE);
                  }
                else if (tmaid->cursor.y > 0)
                  {
                    /* ja:前の行の最後 */
                    tmaid->cursor.y--;
                    tmaid->cursor.x = edit_get_width (tmaid, tmaid->cursor.y);
                  }
                break;
              case GDK_period:
              case GDK_greater:
                if (!ctrl)
                  break;
                width = edit_get_width (tmaid, tmaid->cursor.y);
                if (tmaid->cursor.x < width)
                  {
                    tmaid->cursor.x = edit_get_move_pos (tmaid,
                                    tmaid->cursor.x, tmaid->cursor.y, TRUE);
                  }
                else if (tmaid->cursor.y < tmaid->max - 1)
                  {
                    /* ja:次の行の最初 */
                    tmaid->cursor.x = 0;
                    tmaid->cursor.y++;
                  }
                break;
              case GDK_K:
              case GDK_k:
                if (!alt)
                  return result;
              case GDK_Up:
              case GDK_KP_Up:
                if (!ctrl)
                  {
                    tmaid->cursor.y--;
                  }
                else if (tmaid->top.y > 0)
                  {
                    tmaid->top.y--;
                    if (tmaid->cursor.y - sy + 1 > tmaid->top.y)
                      tmaid->cursor.y--;
                  }
                break;
              case GDK_J:
              case GDK_j:
                if (!alt)
                  return result;
              case GDK_Down:
              case GDK_KP_Down:
                if (!ctrl)
                  {
                    tmaid->cursor.y++;
                  }
                else if (tmaid->top.y < tmaid->max - sy)
                  {
                    tmaid->top.y++;
                    if (tmaid->cursor.y < tmaid->top.y)
                      tmaid->cursor.y++;
                  }
                break;
              case GDK_Page_Up:
              case GDK_KP_Page_Up:
                if (ctrl)
                  {
                    tmaid->cursor.y = tmaid->top.y;
                  }
                else
                  {
                    tmaid->cursor.y -= sy;
                    tmaid->top.y -= sy;
                  }
                break;
              case GDK_Page_Down:
              case GDK_KP_Page_Down:
                if (ctrl)
                  {
                    tmaid->cursor.y = tmaid->top.y + sy - 1;
                  }
                else
                  {
                    tmaid->cursor.y += sy;
                    tmaid->top.y += sy;
                  }
            }
          if (tmaid->cursor.y < 0)
            tmaid->cursor.y = 0;
          else if (tmaid->cursor.y > tmaid->max - 1)
            tmaid->cursor.y = tmaid->max - 1;
          if (tmaid->top.y < 0)
            tmaid->top.y = 0;
          else if (tmaid->top.y > tmaid->max - sy)
            tmaid->top.y = MAX (tmaid->max - sy, 0);
          if (tmaid->cursor.x < tmaid->top.x)
            tmaid->top.x = tmaid->cursor.x;
          else if (tmaid->cursor.x - sx + 1 > tmaid->top.x)
            tmaid->top.x = tmaid->cursor.x - sx + 1;
          if (tmaid->cursor.y < tmaid->top.y)
            tmaid->top.y = tmaid->cursor.y;
          else if (tmaid->cursor.y - sy + 1 > tmaid->top.y)
            tmaid->top.y = tmaid->cursor.y - sy + 1;
          select = tmaid->select;
          if (event->state & GDK_SHIFT_MASK)
            {
              if (tmaid->select.x < 0)
                {
                  /* ja:新たに選択 */
                  tmaid->select.x = edit_get_align_pos (tmaid,
                                                    cursor.x, cursor.y, FALSE);
                  tmaid->select.y = cursor.y;
                }
              if (tmaid->select.y == tmaid->cursor.y && tmaid->select.x
                                    == edit_get_align_pos (tmaid,
                                    tmaid->cursor.x, tmaid->cursor.y, FALSE))
                tmaid->select.x = -1;/* ja:選択範囲が同じとき */
              else
                gtk_selection_owner_set (widget, GDK_SELECTION_PRIMARY,
                                                            GDK_CURRENT_TIME);
            }
          else
            {
              /* ja:選択解除 */
              tmaid->select.x = -1;
            }
          if (tmaid->cursor.x == cursor.x && tmaid->cursor.y == cursor.y
                && tmaid->top.x == top.x && tmaid->top.y == top.y
                && tmaid->select.x == select.x && tmaid->select.y == select.y)
            break;
          if (tmaid->select.x != select.x)
            set_menu_bar (tmaid);
          move_edit_window (tmaid, &top);
          max = edit_get_width_max (tmaid);
          if (tmaid->top.y != top.y)
            misc_set_scroll_bar (tmaid->vscroll,
                        G_CALLBACK (signal_value_changed_vscroll), tmaid,
                        0, tmaid->max, sy, tmaid->top.y);
          if (tmaid->top.x != top.x
                || gtk_range_get_adjustment (GTK_RANGE (tmaid->hscroll))->upper
                                                                        != max)
            misc_set_scroll_bar (tmaid->hscroll,
                            G_CALLBACK (signal_value_changed_hscroll), tmaid,
                                                0, max + 1, sx, tmaid->top.x);
          draw_caret (tmaid, &cursor);
          if (select.x >= 0 && tmaid->select.x < 0)
            clear_sel (tmaid, &select, &cursor);
          else if (tmaid->select.x >= 0)
            clear_sel (tmaid, &tmaid->cursor, &cursor);
        }
        result=TRUE;
        break;
      case GDK_BackSpace:
        {
          TmaidHistory *d;
          GdkPoint select;

          select = tmaid->select;
          if (tmaid->select.x < 0)
            {
              tmaid->cursor.x = edit_get_align_pos (tmaid,
                                    tmaid->cursor.x, tmaid->cursor.y, FALSE);
              if (tmaid->cursor.x > 0)
                {
                  tmaid->select.x = event->state & GDK_CONTROL_MASK
                            ? edit_get_move_pos (tmaid,
                                tmaid->cursor.x, tmaid->cursor.y, FALSE)
                            : edit_get_align_pos (tmaid,
                                tmaid->cursor.x - 1, tmaid->cursor.y, FALSE);
                  tmaid->select.y = tmaid->cursor.y;
                }
              else if (tmaid->cursor.y > 0)
                {
                    /* ja:2つの行を1つにする */
                    tmaid->select.y = tmaid->cursor.y - 1;
                    tmaid->select.x = edit_get_width (tmaid, tmaid->select.y);
                }
              else
                {
                  break;
                }
            }
          d = edit_operation (tmaid, NULL, 0, FALSE, FALSE);
          d->next = tmaid->undo;
          tmaid->undo = d;
          if (delete_list (&tmaid->redo) > 0 || !d->next || select.x >= 0)
            set_menu_bar (tmaid);
          orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), tmaid), TRUE);
        }
        result=TRUE;
        break;
      case GDK_Return:
      case GDK_KP_Enter:
      case GDK_ISO_Enter:
      case GDK_3270_Enter:
        {
          gchar *text;
          gint i, data_pos;
          TmaidHistory *d;
          GdkPoint select;
          LineBuffer *p;

          select = tmaid->select;
          if (tmaid->ft.autoindent)
            {
              data_pos = edit_get_data_pos (tmaid,
                                    tmaid->cursor.x, tmaid->cursor.y, FALSE);
              p = edit_get_line_buf (&tmaid->start, &tmaid->off,
                                                            tmaid->cursor.y);
              for (i = 0; i < data_pos; i++)
                if (p->text[i] != '\t' && p->text[i] != ' ')
                  break;
              text = g_malloc ((i + 1) * sizeof (gchar));
              text[0] = '\n';
              g_memmove (text + 1, p->text, i * sizeof (gchar));
              d = edit_operation (tmaid, text, i + 1, TRUE, FALSE);
              g_free (text);
            }
          else
            {
              d = edit_operation (tmaid, "\n", 1, TRUE, FALSE);
            }
          d->next = tmaid->undo;
          tmaid->undo = d;
          if (delete_list (&tmaid->redo) > 0 || !d->next || select.x >= 0)
            set_menu_bar (tmaid);
          orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), tmaid), TRUE);
        }
        result = TRUE;
        break;
      case GDK_Tab:
      case GDK_KP_Tab:
        {
          gchar *text;
          gint n, align_pos;
          TmaidHistory *d;
          GdkPoint select;

          if (!(event->state & (GDK_CONTROL_MASK | GDK_MOD1_MASK)))
            {
              select=tmaid->select;
              if (tmaid->ft.tabconv ^ ((event->state & GDK_SHIFT_MASK) != 0))
                {
                  align_pos = edit_get_align_pos (tmaid,
                                    tmaid->cursor.x, tmaid->cursor.y, FALSE);
                  n = (align_pos / tmaid->ft.tab + 1) * tmaid->ft.tab
                                                                - align_pos;
                  text = g_strnfill (n, ' ');
                  d = edit_operation (tmaid, text, n, TRUE, FALSE);
                  g_free (text);
                }
              else
                {
                  d = edit_operation (tmaid, "\t", 1, TRUE, FALSE);
                }
              d->next=tmaid->undo;
              tmaid->undo = d;
              if (delete_list (&tmaid->redo) > 0 || !d->next || select.x >= 0)
                set_menu_bar (tmaid);
              orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), tmaid), TRUE);
            }
          else
            {
              gint page;
              guint length;

              length = orz_mdi_get_n_pages (ORZ_MDI (mdi));
              page = gtk_notebook_get_current_page (GTK_NOTEBOOK (mdi));
              if (event->state & GDK_SHIFT_MASK)
                {
                  if (--page<0)
                    page=length-1;
                }
              else
                {
                  if (++page>=length)
                    page=0;
                }
              gtk_notebook_set_page (GTK_NOTEBOOK (mdi), page);
              gtk_widget_grab_focus (((TmaidWindow *)
                            orz_mdi_get_data (ORZ_MDI (mdi), page))->drawing);
            }
        }
        result=TRUE;
        break;
      case GDK_Escape:
      case GDK_Cancel:
        {
          gint sx, sy;
          GdkPoint select, top;

          if (tmaid->select.x < 0)
            break;
          select = tmaid->select;
          top = tmaid->top;
          sx = MAX (tmaid->drawing->allocation.width / tmaid->font_width, 1);
          sy = MAX (tmaid->drawing->allocation.height / tmaid->font_height, 1);
          if (tmaid->cursor.x < tmaid->top.x)
            tmaid->top.x = tmaid->cursor.x;
          else if (tmaid->cursor.x - sx + 1 > tmaid->top.x)
            tmaid->top.x = tmaid->cursor.x - sx + 1;
          if (tmaid->cursor.y < tmaid->top.y)
            tmaid->top.y = tmaid->cursor.y;
          else if (tmaid->cursor.y - sy + 1 > tmaid->top.y)
            tmaid->top.y = tmaid->cursor.y - sy + 1;
          tmaid->select.x = -1;
          set_menu_bar (tmaid);
          move_edit_window (tmaid,&top);
          if (tmaid->top.x != top.x)
            misc_set_scroll_bar (tmaid->hscroll,
                        G_CALLBACK (signal_value_changed_hscroll), tmaid,
                        0, edit_get_width_max (tmaid) + 1, sx, tmaid->top.x);
          if (tmaid->top.y != top.y)
            misc_set_scroll_bar (tmaid->vscroll,
                        G_CALLBACK (signal_value_changed_vscroll), tmaid,
                        0, tmaid->max, sy, tmaid->top.y);
          clear_sel (tmaid, &select, &tmaid->cursor);
          draw_caret (tmaid, NULL);
        }
        result=TRUE;
        break;
      case GDK_Delete:
      case GDK_KP_Delete:
      case GDK_3270_DeleteWord:
        {
          gint width;
          TmaidHistory *d;
          GdkPoint select;

          select = tmaid->select;
          if (tmaid->select.x < 0)
            {
              width = edit_get_width (tmaid, tmaid->cursor.y);
              tmaid->cursor.x = edit_get_align_pos (tmaid,
                                    tmaid->cursor.x, tmaid->cursor.y, FALSE);
              if (tmaid->cursor.x < width)
                {
                  tmaid->select.x = event->state & GDK_CONTROL_MASK
                        ? edit_get_move_pos (tmaid,
                                tmaid->cursor.x, tmaid->cursor.y, TRUE)
                        : edit_get_align_pos (tmaid,
                                tmaid->cursor.x + 1, tmaid->cursor.y, TRUE);
                  tmaid->select.y = tmaid->cursor.y;
                }
              else if (tmaid->cursor.y < tmaid->max - 1)
                {
                  /* ja:2つの行を1つにする */
                  tmaid->select.x = 0;
                  tmaid->select.y = tmaid->cursor.y + 1;
                }
              else
                {
                  break;
                }
            }
          d = edit_operation (tmaid, NULL, 0, FALSE, FALSE);
          d->next = tmaid->undo;
          tmaid->undo = d;
          if (delete_list (&tmaid->redo) > 0 || !d->next || select.x >= 0)
            set_menu_bar (tmaid);
          orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), tmaid), TRUE);
        }
        result = TRUE;
        break;
      case GDK_Insert:
      case GDK_KP_Insert:
        ins = !ins;
        draw_caret (tmaid, NULL);
        result = TRUE;
        break;
      case GDK_Y:
      case GDK_y:
        {
          TmaidHistory *d;
          GdkPoint select;

          if (!(event->state & GDK_CONTROL_MASK))
            break;
          select = tmaid->select;
          if (tmaid->select.x < 0)
            {
              if (tmaid->max-1 <= tmaid->cursor.y)
                {
                  tmaid->cursor.x = 0;
                  tmaid->select.x = edit_get_width (tmaid, tmaid->cursor.y);
                  if (tmaid->select.x <= 0)
                    {
                      if (tmaid->cursor.y <= 0)
                        {
                          tmaid->select.x = -1;
                          return 0;
                        }
                      tmaid->select.y=tmaid->cursor.y-1;
                    }
                  else
                    {
                      tmaid->select.y = tmaid->cursor.y;
                    }
                }
              else
                {
                  tmaid->cursor.x = tmaid->select.x = 0;
                  tmaid->select.y = tmaid->cursor.y + 1;
                }
            }
            d = edit_operation (tmaid, NULL, 0, FALSE, FALSE);
            d->next = tmaid->undo;
            tmaid->undo = d;
            if (delete_list(&tmaid->redo) > 0 || !d->next || select.x >= 0)
              set_menu_bar (tmaid);
              orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), tmaid), TRUE);
        }
        result = TRUE;
        break;
      case GDK_F10:
        {
          gint sx, sy;
          GdkPoint top;
          GtkWidget *menu_shell, *menu_item;

          if (!(event->state & GDK_SHIFT_MASK))
            break;
          top = tmaid->top;
          sx = MAX (tmaid->drawing->allocation.width / tmaid->font_width, 1);
          sy = MAX (tmaid->drawing->allocation.height / tmaid->font_height, 1);
          if (tmaid->cursor.x < tmaid->top.x)
            tmaid->top.x = tmaid->cursor.x;
          else if (tmaid->cursor.x - sx + 1 > tmaid->top.x)
            tmaid->top.x = tmaid->cursor.x - sx + 1;
          if (tmaid->cursor.y < tmaid->top.y)
            tmaid->top.y = tmaid->cursor.y;
          else if (tmaid->cursor.y - sy + 1 > tmaid->top.y)
            tmaid->top.y = tmaid->cursor.y - sy + 1;
          move_edit_window (tmaid, &top);
          if (tmaid->top.x != top.x)
            misc_set_scroll_bar (tmaid->hscroll,
                        G_CALLBACK (signal_value_changed_hscroll), tmaid,
                        0, edit_get_width_max (tmaid) + 1, sx, tmaid->top.x);
          if (tmaid->top.y != top.y)
            misc_set_scroll_bar (tmaid->vscroll,
                        G_CALLBACK (signal_value_changed_vscroll), tmaid,
                        0, tmaid->max, sy, tmaid->top.y);

          menu_item = misc_find_menu (popup_entries, "/input");
          gtk_menu_item_remove_submenu (GTK_MENU_ITEM (menu_item));
          menu_shell = gtk_menu_new ();
          gtk_im_multicontext_append_menuitems (GTK_IM_MULTICONTEXT
                            (tmaid->im_context), GTK_MENU_SHELL (menu_shell));
          gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_item), menu_shell);
          gtk_widget_set_sensitive (misc_find_menu (popup_entries,
                                            "/undo"), tmaid->undo != NULL);
          gtk_widget_set_sensitive (misc_find_menu (popup_entries,
                                            "/cut"), tmaid->select.x >= 0);
          gtk_widget_set_sensitive (misc_find_menu (popup_entries,
                                            "/copy"), tmaid->select.x >= 0);
          gtk_widget_set_sensitive (misc_find_menu (popup_entries,
                                            "/delete"), tmaid->select.x >= 0);
          gtk_menu_popup (GTK_MENU (misc_find_menu (popup_entries, "/")),
                                    NULL, NULL, NULL, NULL, 3, event->time);
        }
        result = TRUE;
    }
  return result;
}


gboolean
signal_key_release (GtkWidget   *widget,
                    GdkEventKey *event,
                    TmaidWindow *tmaid)
{
  return gtk_im_context_filter_keypress (tmaid->im_context, event);
}
