package pantheon.web;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

import java.util.List;

import org.junit.Test;

import pantheon.model.ItemProperty;

public class ItemCommandTest {

	@Test
	public void testGetPointPropertyList() {

		// データ設定
		String[] years = new String[] { "100", null, "200" };
		String[] text = new String[] { "できごとA", null, "できごとB" };

		ItemCommand command = new ItemCommand();
		command.setPropertyFromYear(years);
		command.setPropertyText(text);

		// リスト取得
		List<ItemProperty> propertyList = command.getPointPropertyList();

		// 内容チェック
		assertThat(2, equalTo(propertyList.size()));

		assertThat(100, equalTo(propertyList.get(0).getFromYear()));
		assertThat("できごとA", equalTo(propertyList.get(0).getText()));

		assertThat(200, equalTo(propertyList.get(1).getFromYear()));
		assertThat("できごとB", equalTo(propertyList.get(1).getText()));
	}
}
