package pantheon.web;

import org.junit.Before;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.Validator;

//TODO @SuppressWarnings("unchecked") の一掃
@SuppressWarnings("unchecked")
public abstract class AbstractValidatorTest<C> {
	Validator validator;
	final Class validatorClass;

	BindException exception;
	C command;
	final Class commandClass;

	// TODO ここって<C>からクラスをとれない？
	public AbstractValidatorTest(Class commandClass, Class validatorClass) {
		this.commandClass = commandClass;
		this.validatorClass = validatorClass;
	}

	@Before
	public void before() throws IllegalAccessException, InstantiationException {
		command = (C) commandClass.newInstance();

		BeanPropertyBindingResult result = new BeanPropertyBindingResult(command, command.getClass().getSimpleName());
		exception = new BindException(result);
		validator = (Validator) validatorClass.newInstance();
	}
}
