package pantheon.model.meta;

import static org.hamcrest.core.IsEqual.equalTo;
import static org.junit.Assert.assertThat;

import org.junit.Test;


public class PantheonStringUtilTest {
	@Test
	public void test0() throws Exception {
		assertThat(true, equalTo(PantheonStringUtil.isZenkakuKanaSpace("")));
		assertThat(true, equalTo(PantheonStringUtil.isZenkakuKanaSpace("　")));
		assertThat(true, equalTo(PantheonStringUtil.isZenkakuKanaSpace("ア")));
		assertThat(true, equalTo(PantheonStringUtil.isZenkakuKanaSpace("ァ")));
		assertThat(true, equalTo(PantheonStringUtil.isZenkakuKanaSpace("ロバートハインライン")));
		assertThat(false, equalTo(PantheonStringUtil.isZenkakuKanaSpace("ｱ")));
		assertThat(false, equalTo(PantheonStringUtil.isZenkakuKanaSpace("あ")));
		assertThat(false, equalTo(PantheonStringUtil.isZenkakuKanaSpace("1")));
		assertThat(false, equalTo(PantheonStringUtil.isZenkakuKanaSpace("a")));
	}

}
