package pantheon;

import static org.easymock.EasyMock.createMock;
import static org.easymock.EasyMock.replay;
import static org.easymock.EasyMock.verify;

import org.junit.Before;
import org.junit.Test;

import pantheon.dao.PageDao;
import pantheon.model.Page;
import pantheon.model.PageType;

public class PageServiceImplTest {
	private PageServiceImpl pageService;
	PageDao mockPageDao;

	@Before
	public void setUp() {
		pageService = new PageServiceImpl();
		mockPageDao = createMock(PageDao.class);
		pageService.setPageDao(mockPageDao);

	}

	@Test
	public void insert() throws Exception {

		// モック事後設定
		Page page = new Page("name", PageType.HORIZONTAL_CENTURY, 3, 6);
		Long[] peopleIds = new Long[] { 1L, 3L, 4L };
		mockPageDao.insert(page, peopleIds, null);

		replay(mockPageDao);

		// 実施
		pageService.insert(page, peopleIds, null);

		// モック事後チェック
		verify(mockPageDao);
	}

	@Test
	public void update() throws Exception {

		// モック事後設定
		Page page = new Page(1, "name", PageType.HORIZONTAL_CENTURY, 3, 6);
		Long[] peopleIds = new Long[] { 1L, 3L, 4L };
		mockPageDao.update(page, peopleIds, null);

		replay(mockPageDao);

		// 実施
		pageService.update(page, peopleIds, null);

		// モック事後チェック
		verify(mockPageDao);
	}
}
