<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/jsp/include.jsp" %>

<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title><fmt:message key="view.loginUserInfo.title" /></title>
</head>
<body>
	<%-- メニュー --%>
	<%@ include file="/WEB-INF/jsp/menu.jsp" %>

	<%-- 本文 --%>
	<div id="container" align="center">
		<h2><fmt:message key="view.loginUserInfo.heading" /></h2>
		<div id="container">
			<table>
				<tr>
					<th>
						<fmt:message key="lable.user.id" />
					</th>
					<td>
						<c:out value="${User.id}"></c:out>
					</td>
				</tr>
				<tr>
					<th>
						<fmt:message key="lable.user.name" />
					</th>
					<td>
						<c:out value="${User.userName}"></c:out>
					</td>
				</tr>
				<tr>
					<th>
						<fmt:message key="lable.user.note" />
					</th>
					<td>
						<p style="white-space: pre;"><c:out value="${User.note}" /></p>
					</td>
				</tr>
				<tr>
					<th>
						登録日時
					</th>
					<td>
						<fmt:formatDate pattern="yyyy/MM/dd hh:mm:ss" value="${User.createDate}" />
					</td>
				</tr>
			</table>
			<br />

			<%-- 更新ボタン--%>
			<input type="button"
			       value="<fmt:message key="lable.update"/>"
			       onClick="location.href='<c:url value="/login/update-loginuser.html" />'">
			
		</div>
	</div>
</body>
</html>