<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/jsp/include.jsp" %>

<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><fmt:message key="view.page.title"/></title>
</head>
<body>
	<%-- メニュー --%>
	<%@ include file="/WEB-INF/jsp/menu.jsp" %>

	<%-- 本文 --%>
	<div id="container">

		<div  align="center">
			<%-- 戻るボタン--%>
			<input type="button"
			       value="<fmt:message key="lable.return"/>"
			       onClick="location.href='<c:url value="/page-list.html"/>'">
	
			<%-- 更新ボタン--%>
			<security:authorize ifAnyGranted="ROLE_USER">
				<c:url var="updateUrl" value="/login/update-page.html">
					<c:param name="pageId" value="${model.page.id}" />
				</c:url>
				<input type="button"
				       value="<fmt:message key="lable.update"/>"
				       onClick="location.href='${updateUrl}'">
			</security:authorize>
			<br />
			<br />

			<%-- 年表タイトル --%>
			<h2><fmt:message key="view.page.heading"/>「<c:out value="${model.page.name}" />」</h2>
		</div>

		<%-- 年表本体 --%>
		<div id="container">
			<c:set var="graphLeft" value="15" />

			<c:if test="${model.page.type.code == 1}">
				<c:set var="centuryWidth" value="50" /><%-- 1世紀の幅 --%>
			</c:if>
			<c:if test="${model.page.type.code == 2}">
			
				<c:set var="decadeWidth" value="20" /><%-- 10年期の幅 --%>
				<c:set var="centuryWidth" value="${decadeWidth * 10}" /><%-- 1世紀の幅 --%>
			</c:if>

			<c:set var="fontSize" value="15" />
			<c:set var="headerHeight" value="25" />

			<c:set var="currentTop" value="0" />
			
			<c:set var="recordMargin" value="5" />
			<c:set var="recordHeight" value="20" />

			<c:set var="totalHeight" value="${model.page.recordCountWithSub * (recordHeight + recordMargin)}" />

			<c:set var="barWidth" value="${centuryWidth * model.page.centurySize}" />
			<c:set var="barHeight" value="10" />

			<c:set var="bookImgWidth" value="12" />
			<c:set var="bookImgHeight" value="12" />

			<c:set var="headColor" value="#D8D8D8" />
			<c:set var="color1" value="#add8e6" />
			<div style="position:absolute;">

				<%-- 標題 --%>
				<c:set var="i" value="0" />
				<c:forEach var="century"
				           begin="${model.page.fromCentury.index}"
				           end="${model.page.toCentury.index}"
				           step="1">
					<%-- n世紀--%>
					<div style="position:absolute;
					            left:${graphLeft+i*centuryWidth}px;
					            top:${currentTop}px;
					            width:${centuryWidth}px;
					            height:${headerHeight}px;
					            white-space: nowrap;
					            text-align: center;
					            border:1px #000000 solid;
					            background-color:${headColor};
					            font-size:${fontSize}px;">
						${century}<fmt:message key="lable.century"/>
					</div>
					<c:set var="i" value="${i+1}" />
				</c:forEach>

				<%-- 縦枠--%>
				<c:set var="currentTop"  value="${headerHeight}" />
				<c:set var="i" value="0" />
				<c:forEach var="century"
				           begin="${model.page.fromCentury.index}"
				           end="${model.page.toCentury.index}"
				           step="1">

					<%-- 背景を白一色で埋める（これが無いと10年期のドット線がIEで綺麗に描画されない）--%>
					<div style="position:absolute;
					            left:${graphLeft+i*centuryWidth}px;
					            top:${currentTop}px;
					            width:${centuryWidth}px;
					            height:${totalHeight}px;
					            text-align: center;
					            border:1px #000000 solid;
					            background-color:#ffffff;">
					</div>
					<c:if test="${model.page.type.code == 2}">
						<%-- 10年期 --%>
						<c:forEach var="j" begin="0" end="9" step="1">
							<div style="position:absolute;
							            left:${graphLeft+i*centuryWidth + decadeWidth * j}px;
							            top:${currentTop}px;
							            width:${decadeWidth}px;
							            height:${totalHeight}px;
							            text-align: center;
							            border:1px #999999 dashed;
							            background-color:#ffffff;">
							</div>
						</c:forEach>
						<div style="position:absolute;
					            left:${graphLeft+i*centuryWidth}px;
					            top:${currentTop}px;
					            width:${centuryWidth}px;
					            height:${totalHeight}px;
					            text-align: center;
					            border:1px #000000 solid;
					            background-color:transparent;">
						</div>
					</c:if>
					<c:set var="i" value="${i+1}" />
				</c:forEach>

				<%-- レコード --%>
				<c:set var="currentTop"  value="${currentTop + recordMargin}" />
				<c:forEach items="${model.page.recordList}" var="record">

					<%-- 人物 --%>
					<c:if test="${record.item.type=='PEOPLE'}">
						<%-- PeriodBar --%>
						<c:set var="currentBerLeft"  value="${graphLeft + record.startPosition * barWidth}" />
						<c:set var="currentBerWidth"  value="${(record.endPosition - record.startPosition) * barWidth}" />
						<div style="position:absolute;
						            left:${currentBerLeft}px;
						            top:${currentTop + (recordHeight - barHeight) / 2}px;
						            width:${currentBerWidth}px;
						            height:${barHeight}px;
						            overflow:hidden;
						            background-color:#3333CC;">
						</div>

						<%-- 名前 ,生年,没年--%>
						<div style="position:absolute;
						            left:${currentBerLeft + currentBerWidth + 2}px;
						            top:${currentTop}px;
						            white-space: nowrap;
						            text-align: center;
						            background-color:${color1};
						            font-size:${fontSize}px;">
							&nbsp;${record.people.name}(${record.people.fromYear}<fmt:message key="lable.year"/>-${record.people.toYear}<fmt:message key="lable.year"/>)&nbsp;
							<a href="
								<c:url value="/people.html">
									<c:param name="itemId" value="${record.people.id}" />
								</c:url>">
								<img alt="goto.png" src="<c:url value="/image/goto.png"/>" />
							</a>
						</div>
						<c:set var="currentTop"  value="${currentTop + recordHeight + recordMargin}" />
					</c:if>

					<%-- その他情報--%>
					<c:if test="${record.item.type!='PEOPLE'}">
						<div style="position:absolute;
						            left:${graphLeft + 10}px;
						            top:${currentTop}px;
						            white-space: nowrap;
						            text-align: center;
						            background-color:${color1};
						            font-size:${fontSize}px;">
							&nbsp;${record.item.name}&nbsp;
							<a href="
								<c:url value="/notClassification.html">
									<c:param name="itemId" value="${record.item.id}" />
								</c:url>">
								<img alt="goto.png" src="<c:url value="/image/goto.png"/>" />
							</a>
						</div>
						<c:set var="currentTop"  value="${currentTop + recordHeight + recordMargin}" />
					</c:if>

					<%-- 書籍 --%>
					<c:forEach items="${record.subList}" var="subRecord">
						<c:set var="currentBerLeft"  value="${graphLeft + subRecord.startPosition * barWidth}" />

						<img style="position:absolute;
						            left:${currentBerLeft}px;
						            top:${currentTop + (recordHeight - bookImgHeight) / 2}px;"
						     alt="book.png"
						     src="<c:url value="/image/book.png"/>">

						<div style="position:absolute;
						            left:${currentBerLeft+bookImgWidth + 2}px;
						            top:${currentTop}px;
						            white-space: nowrap;
						            text-align: center;
						            background-color:${color1};
						            font-size:${fontSize}px;" >
							&nbsp;${subRecord.item.name}(${subRecord.item.fromYear}<fmt:message key="lable.year"/>)&nbsp;
							<a href="
								<c:url value="/book.html">
									<c:param name="itemId" value="${subRecord.item.id}" />
								</c:url>">
								<img alt="goto.png" src="<c:url value="/image/goto.png"/>" />
							</a>
						</div>
						
						<c:set var="currentTop"  value="${currentTop + recordHeight + recordMargin}" />
					</c:forEach>

					<%-- 年プロパティ --%>
					<c:forEach items="${record.propertyRecordList}" var="subRecord">
						<c:set var="currentBerLeft"  value="${graphLeft + subRecord.startPosition * barWidth}" />

						<div style="position:absolute;
						            color:#ff8c00;
						            left:${currentBerLeft}px;
						            top:${currentTop + (recordHeight - bookImgHeight) / 2}px;">
							†
						</div>

						<div style="position:absolute;
						            left:${currentBerLeft+bookImgWidth + 2}px;
						            top:${currentTop}px;
						            white-space: nowrap;
						            text-align: center;
						            background-color:${color1};
						            font-size:${fontSize}px;" >
							&nbsp;${subRecord.property.fromYear}<fmt:message key="lable.year"/>&nbsp;${subRecord.property.text}&nbsp;
						</div>
						
						<c:set var="currentTop"  value="${currentTop + recordHeight + recordMargin}" />
					</c:forEach>

				</c:forEach>

			</div>
		</div>
	</div>
</body>
</html>