<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ include file="/WEB-INF/jsp/include.jsp" %>

<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<title><fmt:message key="view.${itemType}History.title"/></title>
</head>
<body>
	<%-- メニュー --%>
	<%@ include file="/WEB-INF/jsp/menu.jsp" %>

	<%-- 本文 --%>
	<div id="container" align="center">
		<h2><fmt:message key="view.${itemType}History.heading"/></h2>
		<table>
			<tr>
				<th><fmt:message key="lable.version.short"/></th>
				<th><fmt:message key="lable.item.name"/></th>
				<th><fmt:message key="lable.item.kanaName" /></th>
				<th><fmt:message key="lable.item.shortName" /></th>
				<th><fmt:message key="lable.item.wikiName" /></th>
				<th><fmt:message key="lable.item.englishName" /></th>
				<c:if test="${itemType.hasFromYear}">
					<th>
						<c:choose>
							<c:when test="${itemType == 'PEOPLE'}"><fmt:message key="lable.people.fromYear"/></c:when>
							<c:when test="${itemType == 'BOOK'}"><fmt:message key="lable.book.fromYear"/></c:when>
						</c:choose>
					</th>
				</c:if>
				<c:if test="${itemType.hasToYear}">
					<th>
						<c:choose>
							<c:when test="${itemType == 'PEOPLE'}"><fmt:message key="lable.people.toYear"/></c:when>
						</c:choose>
					</th>
				</c:if>
				<th><fmt:message key="lable.updateUser"/></th>
				<th><fmt:message key="lable.updateDate"/></th>
			</tr>
			<c:forEach items="${itemList}" var="item">
				<tr>
					<td align="right">
						<a href="
							<c:url value="/${itemType.lowerName}.html">
								<c:param name="itemId" value="${item.id}" />
								<c:param name="version" value="${item.version}" />
							</c:url>">
							<fmt:message key="lable.version.prefix"/><c:out value="${item.version}"/><fmt:message key="lable.version.suffix"/>
						</a>
					</td>
					<td nowrap="nowrap"><c:out value="${item.name}"/></td>
					<td><c:out value="${item.kanaName}"/></td>
					<td><c:out value="${item.shortName}"/></td>
					<td><c:out value="${item.wikiName}"/></td>
					<td><c:out value="${item.englishName}"/></td>
					<c:if test="${itemType.hasFromYear}">
						<td align="right" nowrap="nowrap">
							<c:out value="${item.fromYear}"/><fmt:message key="lable.year"/>
						</td>
					</c:if>
					<c:if test="${itemType.hasToYear}">
						<td align="right" nowrap="nowrap">
							<c:out value="${item.toYear}"/><fmt:message key="lable.year"/>
						</td>
					</c:if>
					<td>
						<a href="
							<c:url value="/user-info.html">
								<c:param name="userId" value="${item.updateUser.id}" />
							</c:url>">
							<c:out value="${item.updateUser.userName}"/>
						</a>
					</td>
					<td>
						<fmt:formatDate pattern="yy/MM/dd hh:mm:ss" value="${item.updateDate}" />
					</td>
				</tr>
			</c:forEach>
		</table>
		<br />
	</div>
</body>
</html>