package pantheon.web;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class PantheonSimpleFormController<C> extends SimpleFormController {

	/** Logger for this class and subclasses */
	protected final Log logger = LogFactory.getLog(getClass());

	// TODO Cからクラスに代入する方法？
	protected final static Class<PageCommand> COMMAND_CLASS = PageCommand.class;
	protected final static String COMMAND_NAME = COMMAND_CLASS.getSimpleName();

	public PantheonSimpleFormController() {
		super();
		setCommandName(COMMAND_NAME);
		setCommandClass(COMMAND_CLASS);
	}

	protected ObjectError createSameNameError(String fieldName, String inputValue) {
		return new FieldError(COMMAND_NAME, fieldName, ValidatorError.editSameNameErrMessage(inputValue));
	}
}
